/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.examples;

import de.iip_ecosphere.platform.examples.PersistentLocalNetworkManagerDescriptor;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.spring.DescriptorUtils;
import de.iip_ecosphere.platform.services.spring.ServerManager;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class SpringStartup {
    public static final String PROPERTY_ARGS = "iip.springStart.args";
    public static final String ARG_BROKER_PORT = "iip.test.brokerPort";
    public static final int DFLT_BROKER_PORT = 8883;
    public static final String ARG_STOP = "iip.test.stop";

    public static void main(String[] args) {
        String sysArgs = System.getProperty(PROPERTY_ARGS, null);
        if (null != sysArgs) {
            List tmp = CollectionUtils.toList((Object[])args);
            if (sysArgs.startsWith("\"") && sysArgs.endsWith("\"") && sysArgs.length() > 1) {
                sysArgs = sysArgs.substring(1, sysArgs.length() - 1);
            }
            CollectionUtils.addAll((List)tmp, (Object[])CmdLine.toArgs((String)sysArgs));
            args = tmp.toArray(new String[0]);
        }
        SpringStartup.start(args);
    }

    public static final void start(String ... args) {
        if (args.length > 0) {
            System.out.println("Artifact args: " + Arrays.toString(args));
            File f = new File(args[0]);
            String[] restArgs = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                restArgs[i - 1] = args[i];
            }
            SpringStartup.start(f, restArgs);
        }
    }

    public static void start(File artifact, String ... args) {
        SpringStartup.start(artifact, true, null, args);
    }

    private static void addAasNotificationMode(String[] args, List<String> cmdArgs) {
        ActiveAasBase.NotificationMode mode = Starter.setAasNotificationMode((String[])args, (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        if (null != mode) {
            cmdArgs.add(CmdLine.composeArgument((String)"iip.test.aas.notification", (Object)mode.name()));
        }
    }

    private static void addAppId(String[] args, List<String> cmdArgs) {
        String appId = CmdLine.getArg((String[])args, (String)"iip.appId", (String)"");
        if (appId.length() > 0) {
            cmdArgs.add(CmdLine.composeArgument((String)"iip.appId", (Object)appId));
        }
    }

    public static void start(File artifact, final boolean doExit, Consumer<ProcessBuilder> procCfg, String ... args) {
        String brokerHost = "localHost";
        int adminPort = -1;
        String serviceProtocol = "";
        PluginManager.registerPlugin((PluginSetupDescriptor)CurrentClassloaderPluginSetupDescriptor.INSTANCE);
        System.setProperty("iip.networkManager", PersistentLocalNetworkManagerDescriptor.class.getName());
        System.out.println("Spring Startup with args: " + Arrays.toString(args));
        System.out.println("System environment: " + String.valueOf(System.getenv()));
        System.out.println("JVM properties: " + String.valueOf(System.getProperties()));
        SpringInstances.setConfig((SpringCloudServiceSetup)new SpringCloudServiceSetup());
        Starter.considerInstalledDependencies();
        int brokerPort = CmdLine.getIntArg((String[])args, (String)ARG_BROKER_PORT, (int)8883);
        final int stop = CmdLine.getIntArg((String[])args, (String)ARG_STOP, (int)0);
        try {
            final ServerManager serverMgr = new ServerManager(() -> NetworkManagerFactory.getInstance());
            final Collection<SpringCloudArtifactDescriptor> artDesc = SpringStartup.getArtifacts(artifact);
            serverMgr.startServers(null, artDesc);
            System.out.println("Command line for artifact: " + String.valueOf(artifact));
            List cmdLine = DescriptorUtils.createStandaloneCommandArgs((File)artifact, (int)brokerPort, (String)brokerHost, (int)adminPort, (String)serviceProtocol);
            SpringStartup.addAasNotificationMode(args, cmdLine);
            SpringStartup.addAppId(args, cmdLine);
            System.out.println("Starting with arguments: " + String.valueOf(cmdLine));
            ProcessBuilder builder = new ProcessBuilder(cmdLine);
            if (null != procCfg) {
                procCfg.accept(builder);
            } else {
                builder.inheritIO();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> serverMgr.stopServers(artDesc)));
            final Process proc = builder.start();
            if (stop > 0) {
                System.out.println("Scheduling for auto-stop after " + stop + " ms");
                final Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.out.println("Auto-stop after: " + stop + " ms");
                        proc.destroyForcibly();
                        serverMgr.stopServers(artDesc);
                        timer.cancel();
                        if (doExit) {
                            System.exit(0);
                        }
                    }
                }, stop);
            }
            proc.waitFor();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            System.err.println("Running the app: " + e.getMessage());
        }
    }

    private static Collection<SpringCloudArtifactDescriptor> getArtifacts(File file) {
        ArrayList<SpringCloudArtifactDescriptor> result = new ArrayList<SpringCloudArtifactDescriptor>();
        YamlArtifact yamlArtifact = null;
        if (null != file) {
            try {
                yamlArtifact = DescriptorUtils.readFromFile((File)file);
                SpringCloudArtifactDescriptor desc = SpringCloudArtifactDescriptor.createInstance((YamlArtifact)yamlArtifact, (URI)file.toURI(), (File)file);
                result.add(desc);
            }
            catch (ExecutionException e) {
                System.out.println("Loading deployment descriptor from : " + e.getMessage() + ". Cannot start servers.");
            }
        } else {
            System.out.println("Loading deployment descriptor from " + String.valueOf(file) + ": Cannot load file, cannot start servers.");
        }
        return result;
    }
}

