/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.kiServices.functions;

import de.iip_ecosphere.platform.kiServices.functions.images.ImageEncodingDecoding;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.kiServices.functions.images.ImageEncodingDecodingTests;
import test.de.iip_ecosphere.platform.kiServices.functions.images.ImageProcessingTests;
import test.de.iip_ecosphere.platform.kiServices.functions.images.QRCodeServiceTest;

public class ImageTests {
    public static final String TEST_FILE_FOLDER = "src/test/resources";

    @Test
    public void testEncodingDecoding() {
        BufferedImage image = ImageEncodingDecodingTests.testReadBase64StringAsBufferedImage();
        Assert.assertTrue((image != null ? 1 : 0) != 0);
        String imageString = ImageEncodingDecodingTests.testReadImageToBase64String();
        Assert.assertFalse((boolean)imageString.isEmpty());
        imageString = ImageEncodingDecodingTests.testReadingBase64AsString();
        Assert.assertFalse((boolean)imageString.isEmpty());
        image = ImageEncodingDecodingTests.testReadingInImageAsBufferedImage();
        Assert.assertTrue((image != null ? 1 : 0) != 0);
    }

    @Test
    public void testQRFunctionality() {
        String base64Iamge = null;
        BufferedImage image = null;
        try {
            base64Iamge = ImageEncodingDecoding.readBase64ImageFromBase64File((String)"src/test/resources/testImageAsBytesb64");
            image = ImageEncodingDecoding.base64StringToBufferdImage((String)base64Iamge);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String qr = QRCodeServiceTest.testJavaQRCodeDetection(image);
        Assert.assertTrue((boolean)qr.equals("https://aas.uni-h.de/0016"));
        qr = "";
    }

    @Test
    public void testImageProcesssing() {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File("src/test/resources/testImage.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedImage gray = ImageProcessingTests.testGrayscaling(image);
        Assert.assertTrue((gray != null ? 1 : 0) != 0);
        BufferedImage rescale = ImageProcessingTests.testRescalingOfImage(image, 500, 500);
        Assert.assertTrue((rescale != null ? 1 : 0) != 0);
        BufferedImage blackWhite = ImageProcessingTests.testThresholdingImage(image, 120);
        Assert.assertTrue((blackWhite != null ? 1 : 0) != 0);
    }
}

