/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.kiServices.functions.aggregation;

import de.iip_ecosphere.platform.kiServices.functions.aggregation.ChannelTimeSeriesAggregator;
import de.iip_ecosphere.platform.kiServices.functions.aggregation.MultiChannelTimeSeriesAggregator;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class ChannelTimeSeriesAggregatorTest {
    private static Double getValue(PlcEnergyMeasurement input) {
        Double result;
        try {
            result = Double.valueOf(input.value);
        }
        catch (NumberFormatException ex) {
            result = -1.0;
            LoggerFactory.getLogger(ChannelTimeSeriesAggregatorTest.class).info("Cannot add received value: {}", (Object)ex.getMessage());
        }
        return result;
    }

    private static Double getValue(MultiPlcEnergyMeasurementDatapoint input) {
        Double result;
        try {
            result = Double.valueOf(input.value);
        }
        catch (NumberFormatException ex) {
            result = -1.0;
            LoggerFactory.getLogger(ChannelTimeSeriesAggregatorTest.class).info("Cannot add received value: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Test
    public void testAggregator() {
        this.testAggregator(new AggFunction());
    }

    @Test
    public void testLambdaAggregator() {
        this.testAggregator((MultiChannelTimeSeriesAggregator.AggregationFunction<PlcEnergyMeasurement, PlcEnergyMeasurement, AggregatedPlcEnergyMeasurement, Double, Date>)new MultiChannelTimeSeriesAggregator.LambdaBasedAggregationFunction(d -> d.timestamp, d -> d.channel, d -> ChannelTimeSeriesAggregatorTest.getValue(d), (n, t) -> n >= 3, s -> new AggFunction().createResult((int)s)));
    }

    private void testAggregator(MultiChannelTimeSeriesAggregator.AggregationFunction<PlcEnergyMeasurement, PlcEnergyMeasurement, AggregatedPlcEnergyMeasurement, Double, Date> aggFunc) {
        Date now = Calendar.getInstance().getTime();
        PlcEnergyMeasurement[] data = new PlcEnergyMeasurement[3];
        data[0] = new PlcEnergyMeasurement();
        data[0].timestamp = now;
        data[0].channel = "ch1";
        data[0].value = "1";
        data[1] = new PlcEnergyMeasurement();
        data[1].timestamp = now;
        data[1].channel = "ch2";
        data[1].value = "2";
        data[2] = new PlcEnergyMeasurement();
        data[2].timestamp = now;
        data[2].channel = "ch3";
        data[2].value = "3";
        ChannelTimeSeriesAggregator agg = new ChannelTimeSeriesAggregator(aggFunc);
        agg.stopAggregating();
        agg.startAggregating();
        AggregatedPlcEnergyMeasurement res = null;
        for (int s = 1; s <= 5; ++s) {
            for (int d = 0; d < data.length; ++d) {
                AggregatedPlcEnergyMeasurement tmp = (AggregatedPlcEnergyMeasurement)agg.process((Object)data[d]);
                if (null == tmp || null != res) continue;
                res = tmp;
            }
        }
        agg.stopAggregating();
        Assert.assertNotNull(res);
        Assert.assertNotNull((Object)res.channels);
        Assert.assertEquals((long)3L, (long)res.channels.length);
        HashMap<String, double[]> collectedTestData = new HashMap<String, double[]>();
        for (int c = 0; c < res.channels.length; ++c) {
            PlcEnergyMeasurementChannel channel = res.channels[c];
            Assert.assertNotNull((Object)channel.channel);
            Assert.assertNotNull((Object)channel.values);
            Assert.assertEquals((long)3L, (long)channel.values.length);
            Assert.assertTrue((channel.samplerate > 0.0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)channel.timestamp);
            collectedTestData.put(channel.channel, channel.values);
        }
        Assert.assertEquals((long)3L, (long)collectedTestData.size());
        for (Map.Entry e : collectedTestData.entrySet()) {
            String channel = (String)e.getKey();
            for (int i = 0; i < ((double[])e.getValue()).length; ++i) {
                Assert.assertEquals((Object)channel, (Object)("ch" + (int)((double[])e.getValue())[i]));
            }
        }
    }

    @Test
    public void testMultiAggregation() {
        MultiPlcEnergyMeasurement data = new MultiPlcEnergyMeasurement();
        data.datapoints.timestamp = Calendar.getInstance().getTime();
        data.datapoints.datapoints = new MultiPlcEnergyMeasurementDatapoint[3];
        data.datapoints.datapoints[0] = new MultiPlcEnergyMeasurementDatapoint();
        data.datapoints.datapoints[0].channel = "ch1";
        data.datapoints.datapoints[0].value = "1";
        data.datapoints.datapoints[1] = new MultiPlcEnergyMeasurementDatapoint();
        data.datapoints.datapoints[1].channel = "ch2";
        data.datapoints.datapoints[1].value = "2";
        data.datapoints.datapoints[2] = new MultiPlcEnergyMeasurementDatapoint();
        data.datapoints.datapoints[2].channel = "ch3";
        data.datapoints.datapoints[2].value = "3";
        MultiChannelTimeSeriesAggregator.LambdaBasedAggregationFunction aggFunc = new MultiChannelTimeSeriesAggregator.LambdaBasedAggregationFunction(d -> d.datapoints.timestamp, d -> d.channel, d -> ChannelTimeSeriesAggregatorTest.getValue(d), (n, t) -> n >= 3, s -> new AggFunction().createResult((int)s));
        MultiChannelTimeSeriesAggregator agg = new MultiChannelTimeSeriesAggregator(true, (MultiChannelTimeSeriesAggregator.AggregationFunction)aggFunc, d -> new MultiChannelTimeSeriesAggregator.ArrayIterator((Object[])d.datapoints.datapoints));
        agg.stopAggregating();
        agg.startAggregating();
        agg.process((Object)data);
        agg.process((Object)data);
        agg.process((Object)data);
        AggregatedPlcEnergyMeasurement res = (AggregatedPlcEnergyMeasurement)agg.process((Object)data);
        agg.stopAggregating();
        Assert.assertNotNull((Object)res);
        Assert.assertNotNull((Object)res.channels);
        Assert.assertEquals((long)3L, (long)res.channels.length);
        HashMap<String, double[]> collectedTestData = new HashMap<String, double[]>();
        for (int c = 0; c < res.channels.length; ++c) {
            PlcEnergyMeasurementChannel channel = res.channels[c];
            Assert.assertNotNull((Object)channel.channel);
            Assert.assertNotNull((Object)channel.values);
            Assert.assertEquals((long)3L, (long)channel.values.length);
            Assert.assertTrue((channel.samplerate > 0.0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)channel.timestamp);
            collectedTestData.put(channel.channel, channel.values);
        }
        Assert.assertEquals((long)3L, (long)collectedTestData.size());
        for (Map.Entry e : collectedTestData.entrySet()) {
            String channel = (String)e.getKey();
            for (int i = 0; i < ((double[])e.getValue()).length; ++i) {
                Assert.assertEquals((Object)channel, (Object)("ch" + (int)((double[])e.getValue())[i]));
            }
        }
    }

    @Test
    public void testAggregator_initFail() {
        try {
            new ChannelTimeSeriesAggregator(null);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleValueIterator() {
        MultiChannelTimeSeriesAggregator.SingleValueIterator iter = new MultiChannelTimeSeriesAggregator.SingleValueIterator((Object)1);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((1 == (Integer)iter.next() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            Assert.fail((String)"No exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayIterator() {
        MultiChannelTimeSeriesAggregator.ArrayIterator iter = new MultiChannelTimeSeriesAggregator.ArrayIterator((Object[])new Integer[0]);
        Assert.assertFalse((boolean)iter.hasNext());
        Object[] array = new Integer[]{1, 2};
        iter = new MultiChannelTimeSeriesAggregator.ArrayIterator(array);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((1 == (Integer)iter.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((2 == (Integer)iter.next() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            Assert.fail((String)"No exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static class PlcEnergyMeasurement {
        private String value;
        private Date timestamp;
        private String channel;

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class MultiPlcEnergyMeasurementDatapoint {
        private String value;
        private String channel;

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    private static class AggFunction
    implements MultiChannelTimeSeriesAggregator.AggregationFunction<PlcEnergyMeasurement, PlcEnergyMeasurement, AggregatedPlcEnergyMeasurement, Double, Date>,
    MultiChannelTimeSeriesAggregator.ResultBuilder<AggregatedPlcEnergyMeasurement, Double, Date> {
        private PlcEnergyMeasurementChannel[] channels;
        private int pos;

        private AggFunction() {
        }

        public Date getTimestamp(PlcEnergyMeasurement input) {
            return input.timestamp;
        }

        public String getCategory(PlcEnergyMeasurement input) {
            return input.channel;
        }

        public Double getData(PlcEnergyMeasurement input) {
            return ChannelTimeSeriesAggregatorTest.getValue(input);
        }

        public boolean chunkCompleted(int numberAggregatedSamples, Date timestamp) {
            return numberAggregatedSamples >= 3;
        }

        public MultiChannelTimeSeriesAggregator.ResultBuilder<AggregatedPlcEnergyMeasurement, Double, Date> createResult(int categoriesCount) {
            this.pos = 0;
            this.channels = new PlcEnergyMeasurementChannel[categoriesCount];
            return this;
        }

        public void addData(String category, List<Double> data, Date timestamp) {
            PlcEnergyMeasurementChannel ch = new PlcEnergyMeasurementChannel();
            ch.channel = category;
            ch.samplerate = 0.25;
            ch.timestamp = timestamp;
            double[] valsArray = new double[data.size()];
            int size = data.size();
            for (int v = 0; v < size; ++v) {
                valsArray[v] = data.get(v);
            }
            ch.values = valsArray;
            this.channels[this.pos++] = ch;
        }

        public AggregatedPlcEnergyMeasurement build() {
            AggregatedPlcEnergyMeasurement result = new AggregatedPlcEnergyMeasurement();
            result.channels = this.channels;
            this.pos = 0;
            this.channels = null;
            return result;
        }
    }

    public static class AggregatedPlcEnergyMeasurement {
        private PlcEnergyMeasurementChannel[] channels;

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class PlcEnergyMeasurementChannel {
        private double[] values;
        private Date timestamp;
        private String channel;
        private double samplerate;

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class MultiPlcEnergyMeasurement {
        private MultiPlcEnergyMeasurementDatapoints datapoints = new MultiPlcEnergyMeasurementDatapoints();
    }

    public static class MultiPlcEnergyMeasurementDatapoints {
        private Date timestamp;
        private MultiPlcEnergyMeasurementDatapoint[] datapoints;

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }
}

