/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.kiServices.functions.images;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;

public class ImageProcessing {
    public static BufferedImage grayScaleImage(BufferedImage bufferedImage) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(bufferedImage, bufferedImage);
        return bufferedImage;
    }

    public static BufferedImage thresholdImage(BufferedImage image, int threshold) {
        image = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        image.getGraphics().drawImage(image, 0, 0, null);
        WritableRaster raster = image.getRaster();
        int[] pixels = new int[image.getWidth()];
        for (int y = 0; y < image.getHeight(); ++y) {
            raster.getPixels(0, y, image.getWidth(), 1, pixels);
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = pixels[i] < threshold ? 0 : 255;
            }
            raster.setPixels(0, y, image.getWidth(), 1, pixels);
        }
        return image;
    }

    public static BufferedImage rescaleImage(BufferedImage image, int targetHeight, int targetWidth) {
        Image resultingImage = image.getScaledInstance(targetWidth, targetHeight, 1);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }
}

