/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.kiServices.functions.images;

import de.iip_ecosphere.platform.support.IOUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;

public class ImageEncodingDecoding {
    public static BufferedImage base64StringToBufferdImage(String imageString) throws IOException {
        byte[] bytes = Base64.getDecoder().decode(imageString);
        BufferedImage image = null;
        ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
        image = ImageIO.read(byteInput);
        byteInput.close();
        return image;
    }

    public static String bufferedImageToBase64String(BufferedImage bimage) {
        String image = "";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bimage, "jpg", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] array = baos.toByteArray();
        image = Base64.getEncoder().encodeToString(array);
        return image;
    }

    public static BufferedImage readBase64FileAsBufferedImage(String inPath) throws IOException {
        BufferedImage image = null;
        String imageString = ImageEncodingDecoding.readBase64ImageFromBase64File(inPath);
        image = ImageEncodingDecoding.base64StringToBufferdImage(imageString);
        return image;
    }

    public static BufferedImage readBufferedImageFromFile(String inPath) throws IOException {
        BufferedImage image = null;
        image = ImageIO.read(new File(inPath));
        return image;
    }

    public static String readImageAsBase64String(String inPath) throws IOException {
        String base64EncodedImage = "";
        FileInputStream inputstream = new FileInputStream(new File(inPath));
        byte[] array = IOUtils.toByteArray((InputStream)inputstream);
        inputstream.close();
        base64EncodedImage = Base64.getEncoder().encodeToString(array);
        return base64EncodedImage;
    }

    public static String readBase64ImageFromBase64File(String path) throws IOException {
        byte[] imageBytes = new byte[]{};
        FileInputStream readImage = new FileInputStream(path);
        imageBytes = IOUtils.toByteArray((InputStream)readImage);
        ((InputStream)readImage).close();
        return new String(imageBytes, StandardCharsets.UTF_8);
    }
}

