/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.tools.maven.python;

import de.iip_ecosphere.platform.tools.maven.python.PythonCompileMojo;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.tools.maven.python.AbstractTest;

public class PythonCompileTest
extends AbstractTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testOk() throws Exception {
        this.testOk(true);
        this.testOk(false);
    }

    private void testOk(boolean cleanFirst) throws Exception {
        MavenProject project = this.readMavenProject(new File("src/test/resources/unit/project-ok"));
        PythonCompileMojo myMojo = (PythonCompileMojo)this.lookupConfiguredMojo(project, "compile-python");
        PythonCompileTest.assertNotNull((Object)myMojo);
        PythonCompileTest.cleanMd5File(cleanFirst, myMojo);
        myMojo.execute();
        PythonCompileTest.assertMd5File(myMojo);
        PythonCompileTest.cleanMd5File(!cleanFirst, myMojo);
    }

    @Test
    public void testFail() throws Exception {
        this.testFail(true);
        this.testFail(false);
    }

    private void testFail(boolean cleanFirst) throws Exception {
        MavenProject project = this.readMavenProject(new File("src/test/resources/unit/project-fail"));
        PythonCompileMojo myMojo = (PythonCompileMojo)this.lookupConfiguredMojo(project, "compile-python");
        PythonCompileTest.assertNotNull((Object)myMojo);
        PythonCompileTest.cleanMd5File(cleanFirst, myMojo);
        try {
            myMojo.execute();
            Assert.fail((String)"No failure");
        }
        catch (MojoExecutionException mojoExecutionException) {
            // empty catch block
        }
        PythonCompileTest.cleanMd5File(!cleanFirst, myMojo);
    }

    private static void assertMd5File(PythonCompileMojo mojo) {
        Assert.assertTrue((boolean)mojo.getHashFile().exists());
    }

    private static void cleanMd5File(boolean clean, PythonCompileMojo mojo) {
        if (clean) {
            FileUtils.deleteQuietly((File)mojo.getHashFile().getParentFile());
        }
    }
}

