/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.MD5;

public class DEvent
implements Cloneable {
    private String uid;
    private String correlationId;
    private String prometheusId;
    private long timestamp;
    private int counter = 1;
    private long firstTimestamp;
    private long lastTimestamp;
    private long clearTimestamp;
    private String source;
    private String userAgent;
    private String alertname;
    private String info;
    private String job;
    private String instance;
    private String nodename;
    private String hostname;
    private String severity;
    private String priority;
    private String clearUid = "n/a";
    private String tags;
    private String description;
    private String group;
    private String eventType = "5";
    private String probableCause = "1024";
    private String currentValue;
    private String url;
    private String status;
    private String generatorUrl;
    private boolean toBeDeleted = false;
    private Map<String, String> otherLabels;
    private String otherLabelsString;
    private String ruleExpression = "";
    private String ruleTimeLimit;
    public static final String LBL_ALERTNAME = "alertname";
    public static final String LBL_INFO = "info";
    public static final String LBL_INSTANCE = "instance";
    public static final String LBL_NODENAME = "nodename";
    public static final String LBL_JOB = "job";
    public static final String LBL_TAGS = "tags";
    public static final String LBL_SEVERITY = "severity";
    public static final String LBL_PRIORITY = "priority";
    public static final String LBL_GROUP = "group";
    public static final String LBL_EVENTTYPE = "eventType";
    public static final String LBL_PROBABLECAUSE = "probableCause";
    public static final String LBL_URL = "url";
    public static final String LBL_DESCRIPTION = "description";
    public static final String LBL_CURRENTVALUE = "currentValue";

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getPrometheusId() {
        return this.prometheusId;
    }

    public void setPrometheusId(String prometheusId) {
        this.prometheusId = prometheusId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getFormatedTimestamp() {
        return Formatter.getFormatedTimestamp(this.timestamp);
    }

    public String getFormatedFirstTimestamp() {
        return Formatter.getFormatedTimestamp(this.firstTimestamp);
    }

    public String getFormatedLastTimestamp() {
        return Formatter.getFormatedTimestamp(this.lastTimestamp);
    }

    public String getFormatedClearTimestamp() {
        return Formatter.getFormatedTimestamp(this.clearTimestamp);
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public long getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public void setFirstTimestamp(long firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(long lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public long getClearTimestamp() {
        return this.clearTimestamp;
    }

    public void setClearTimestamp(long clearTimestamp) {
        this.clearTimestamp = clearTimestamp;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getAlertname() {
        return this.alertname;
    }

    public void setAlertname(String alertname) {
        this.alertname = alertname;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getNodename() {
        return this.nodename;
    }

    public void setNodename(String nodename) {
        this.nodename = nodename;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getClearUid() {
        return this.clearUid;
    }

    public void setClearUid(String clearUid) {
        this.clearUid = clearUid;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getProbableCause() {
        return this.probableCause;
    }

    public void setProbableCause(String probableCause) {
        this.probableCause = probableCause;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getGeneratorUrl() {
        return this.generatorUrl;
    }

    public void setGeneratorUrl(String generatorUrl) {
        this.generatorUrl = generatorUrl;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public String getRuleExpression() {
        return this.ruleExpression;
    }

    public void setRuleExpression(String ruleExpression) {
        this.ruleExpression = ruleExpression;
    }

    public String getRuleTimeLimit() {
        return this.ruleTimeLimit;
    }

    public void setRuleTimeLimit(String ruleTimeLimit) {
        this.ruleTimeLimit = ruleTimeLimit;
    }

    public Map<String, String> getOtherLabels() {
        return this.otherLabels;
    }

    public void setOtherLabels(Map<String, String> labels) {
        if (this.otherLabels == null) {
            this.otherLabels = new HashMap<String, String>();
        }
        this.otherLabels = labels;
        this.otherLabels.remove(LBL_ALERTNAME);
        this.otherLabels.remove(LBL_INFO);
        this.otherLabels.remove(LBL_INSTANCE);
        this.otherLabels.remove(LBL_NODENAME);
        this.otherLabels.remove(LBL_JOB);
        this.otherLabels.remove(LBL_TAGS);
        this.otherLabels.remove(LBL_SEVERITY);
        this.otherLabels.remove(LBL_PRIORITY);
        this.otherLabels.remove(LBL_GROUP);
        this.otherLabels.remove(LBL_EVENTTYPE);
        this.otherLabels.remove(LBL_PROBABLECAUSE);
        this.otherLabels.remove(LBL_URL);
        this.otherLabels.remove(LBL_DESCRIPTION);
        String[] lblArray = AmProps.ALERTMONITOR_PROMETHEUS_ID_LABELS.split(",");
        for (int i = 0; i < lblArray.length; ++i) {
            this.otherLabels.remove(lblArray[i].trim());
        }
        this.otherLabelsString = this.otherLabels.toString();
    }

    public String getOtherLabelsString() {
        return this.otherLabelsString;
    }

    public void setOtherLabelsString(String otherLabelsString) {
        this.otherLabelsString = otherLabelsString;
    }

    public void generateUID() {
        this.uid = MD5.getChecksum(this.timestamp + (long)this.hashCode() + (long)new Random().nextInt(Integer.MAX_VALUE) + this.priority + new Random().nextInt(Integer.MAX_VALUE) + this.alertname + new Random().nextInt(Integer.MAX_VALUE) + this.info + new Random().nextInt(Integer.MAX_VALUE) + this.group + new Random().nextInt(Integer.MAX_VALUE) + this.instance + new Random().nextInt(Integer.MAX_VALUE) + this.description + new Random().nextInt(Integer.MAX_VALUE) + this.source + new Random().nextInt(Integer.MAX_VALUE) + this.userAgent + new Random().nextInt(Integer.MAX_VALUE) + this.severity + new Random().nextInt(Integer.MAX_VALUE) + this.tags);
    }

    public void generateCID() {
        this.correlationId = MD5.getChecksum(this.alertname + this.info + this.instance + this.job);
    }

    public DEvent generateClearEvent() {
        try {
            long now = System.currentTimeMillis();
            DEvent eClone = (DEvent)this.clone();
            eClone.setTimestamp(now);
            eClone.setClearTimestamp(now);
            eClone.setSeverity("clear");
            eClone.setSource("PSYNC");
            eClone.generateUID();
            return eClone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "DEvent{uid='" + this.uid + '\'' + ", correlationId='" + this.correlationId + '\'' + ", prometheusId='" + this.prometheusId + '\'' + ", timestamp=" + this.timestamp + ", counter=" + this.counter + ", firstTimestamp=" + this.firstTimestamp + ", lastTimestamp=" + this.lastTimestamp + ", clearTimestamp=" + this.clearTimestamp + ", source='" + this.source + '\'' + ", userAgent='" + this.userAgent + '\'' + ", alertname='" + this.alertname + '\'' + ", info='" + this.info + '\'' + ", job='" + this.job + '\'' + ", instance='" + this.instance + '\'' + ", nodename='" + this.nodename + '\'' + ", hostname='" + this.hostname + '\'' + ", severity='" + this.severity + '\'' + ", priority='" + this.priority + '\'' + ", clearUid='" + this.clearUid + '\'' + ", tags='" + this.tags + '\'' + ", description='" + this.description + '\'' + ", group='" + this.group + '\'' + ", eventType='" + this.eventType + '\'' + ", probableCause='" + this.probableCause + '\'' + ", currentValue='" + this.currentValue + '\'' + ", url='" + this.url + '\'' + ", status='" + this.status + '\'' + ", generatorUrl='" + this.generatorUrl + '\'' + ", toBeDeleted=" + this.toBeDeleted + ", otherLabels=" + this.otherLabels + ", ruleExpression='" + this.ruleExpression + '\'' + ", ruleTimeLimit='" + this.ruleTimeLimit + '\'' + '}';
    }
}

