/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.prometheus.client.Counter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.data.IDataManager;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class MongoDbDataManager
implements IDataManager {
    private static SimpleLogger logger = LogFactory.getLogger();
    public static String dbName = "alertmonitor";
    private MongoClient mongoClient;

    public MongoDbDataManager() {
        int timeoutSeconds = 5;
        MongoClientSettings settings = MongoClientSettings.builder().applyToSocketSettings(builder -> {
            builder.connectTimeout(timeoutSeconds * 1000, TimeUnit.MILLISECONDS);
            builder.readTimeout(timeoutSeconds * 1000, TimeUnit.MILLISECONDS);
        }).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)(timeoutSeconds * 1000), TimeUnit.MILLISECONDS)).applyConnectionString(new ConnectionString(AmProps.ALERTMONITOR_MONGODB_CONNECTION_STRING)).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)settings);
        logger.info("MongoDbDataManager initialized");
    }

    @Override
    public void addWebhookMessage(WebhookMessage message) {
        logger.info("MongoDbDataManager: addWebhookMessage");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("webhook");
            Document doc = new Document("_id", (Object)new ObjectId());
            doc.append("id", (Object)message.getId()).append("runtimeId", (Object)message.getRuntimeId()).append("timestamp", (Object)message.getTimestamp()).append("contentLength", (Object)message.getContentLength()).append("contentType", (Object)message.getContentType()).append("method", (Object)message.getMethod()).append("protocol", (Object)message.getProtocol()).append("remoteHost", (Object)message.getRemoteHost()).append("remotePort", (Object)message.getRemotePort()).append("requestUri", (Object)message.getRequestUri()).append("headerMap", message.getHeaderMap()).append("headerMapString", (Object)message.getHeaderMapString()).append("parameterMap", message.getParameterMap()).append("parameterMapString", (Object)message.getParameterMapString()).append("body", (Object)message.getBody());
            collection.insertOne((Object)doc);
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_inserts_total.labels(new String[]{"webhook"})).inc();
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: addWebhookMessage: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
        }
    }

    @Override
    public List<WebhookMessage> getWebhookMessages() {
        logger.info("MongoDbDataManager: getWebhookMessages");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("webhook");
            List docsResultList = (List)collection.find(Filters.eq((String)"runtimeId", (Object)AmProps.ALERTMONITOR_RUNTIME_ID)).sort(Sorts.descending((String[])new String[]{"id"})).limit(100).into(new ArrayList());
            logger.info("MongoDbDataManager: docsResultList size=" + docsResultList.size());
            ArrayList<WebhookMessage> webhookMessageList = new ArrayList<WebhookMessage>();
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            for (Document doc : docsResultList) {
                WebhookMessage m = new WebhookMessage();
                m.setId(((Number)doc.get((Object)"id")).longValue());
                m.setRuntimeId(doc.getString((Object)"runtimeId"));
                m.setTimestamp(((Number)doc.get((Object)"timestamp")).longValue());
                m.setContentLength(doc.getInteger((Object)"contentLength"));
                m.setContentType(doc.getString((Object)"contentType"));
                m.setMethod(doc.getString((Object)"method"));
                m.setProtocol(doc.getString((Object)"protocol"));
                m.setRemoteHost(doc.getString((Object)"remoteHost"));
                m.setRemotePort(doc.getInteger((Object)"remotePort"));
                m.setRequestUri(doc.getString((Object)"requestUri"));
                m.setBody(doc.getString((Object)"body"));
                m.setHeaderMapString(doc.getString((Object)"headerMapString"));
                m.setParameterMapString(doc.getString((Object)"parameterMapString"));
                webhookMessageList.add(m);
            }
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_queries_total.labels(new String[]{"webhook"})).inc();
            return webhookMessageList;
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: getWebhookMessages: Exception: ", (Throwable)e);
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
            return null;
        }
    }

    @Override
    public void addToJournal(List<DEvent> events) {
        if (events.size() == 0) {
            return;
        }
        logger.info("MongoDbDataManager: add to journal (" + events.size() + ")");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            ArrayList<Document> list = new ArrayList<Document>();
            for (DEvent e : events) {
                LogFactory.getLogger().debug("MongoDbDataManager: adding to journal uid=" + e.getUid());
                Document doc = Document.parse((String)new Gson().toJson((Object)e));
                list.add(doc);
            }
            collection.insertMany(list, new InsertManyOptions().ordered(false));
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_inserts_total.labels(new String[]{"journal"})).inc();
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: addToJournal(): Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
        }
    }

    @Override
    public List<DEvent> getJournal() {
        logger.info("MongoDbDataManager: getJournal");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            List docsResultList = (List)collection.find().sort(Sorts.descending((String[])new String[]{"timestamp"})).limit(1000).into(new ArrayList());
            logger.info("MongoDbDataManager: docsResultList size=" + docsResultList.size());
            ArrayList<DEvent> eventList = new ArrayList<DEvent>();
            for (Document doc : docsResultList) {
                DEvent e = this.convertToDEvent(doc);
                eventList.add(e);
            }
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_queries_total.labels(new String[]{"journal"})).inc();
            return eventList;
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: getJournal: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
            return null;
        }
    }

    @Override
    public long getJournalSize() {
        logger.info("MongoDbDataManager: getJournalSize");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_queries_total.labels(new String[]{"journal"})).inc();
            return collection.countDocuments();
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: getJournalSize: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
            return -1L;
        }
    }

    @Override
    public int getNumberOfAlertsInLastHour() {
        logger.info("MongoDbDataManager: getNumberOfAlertsInLastHour");
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            Bson filter = Filters.gte((String)"timestamp", (Object)(System.currentTimeMillis() - 3600000L));
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_queries_total.labels(new String[]{"journal"})).inc();
            return (int)collection.countDocuments(filter);
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: getNumberOfAlertsInLastHour: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
            return -1;
        }
    }

    @Override
    public String getAlertsPerSecondInLastHour() {
        int i = this.getNumberOfAlertsInLastHour();
        if (i < 0) {
            return "n/a";
        }
        double perSecond = (double)i / 3600.0;
        DecimalFormat df2 = new DecimalFormat("#.###");
        return df2.format(perSecond);
    }

    @Override
    public DEvent getEvent(String id) {
        logger.info("MongoDbDataManager: getEvent id=" + id);
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            Document doc = (Document)collection.find(Filters.eq((String)"uid", (Object)id)).first();
            DEvent event = this.convertToDEvent(doc);
            DAO.getInstance().removeWarning("mongo");
            ((Counter.Child)AmMetrics.alertmonitor_db_queries_total.labels(new String[]{"journal"})).inc();
            return event;
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: getEvent: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
            return null;
        }
    }

    private DEvent convertToDEvent(Document doc) {
        DEvent event = new DEvent();
        event.setUid(doc.getString((Object)"uid"));
        event.setCorrelationId(doc.getString((Object)"correlationId"));
        event.setTimestamp(((Number)doc.get((Object)"timestamp")).longValue());
        event.setFirstTimestamp(((Number)doc.get((Object)"firstTimestamp")).longValue());
        event.setLastTimestamp(((Number)doc.get((Object)"lastTimestamp")).longValue());
        event.setClearTimestamp(((Number)doc.get((Object)"clearTimestamp")).longValue());
        event.setClearUid(doc.getString((Object)"clearUid"));
        event.setCounter(doc.getInteger((Object)"counter"));
        event.setSource(doc.getString((Object)"source"));
        event.setUserAgent(doc.getString((Object)"userAgent"));
        event.setAlertname(doc.getString((Object)"alertname"));
        event.setInfo(doc.getString((Object)"info"));
        event.setInstance(doc.getString((Object)"instance"));
        event.setHostname(doc.getString((Object)"hostname"));
        event.setNodename(doc.getString((Object)"nodename"));
        event.setJob(doc.getString((Object)"job"));
        event.setTags(doc.getString((Object)"tags"));
        event.setSeverity(doc.getString((Object)"severity"));
        event.setPriority(doc.getString((Object)"priority"));
        event.setGroup(doc.getString((Object)"group"));
        event.setEventType(doc.getString((Object)"eventType"));
        event.setProbableCause(doc.getString((Object)"probableCause"));
        event.setCurrentValue(doc.getString((Object)"currentValue"));
        event.setUrl(doc.getString((Object)"url"));
        event.setDescription(doc.getString((Object)"description"));
        event.setStatus(doc.getString((Object)"status"));
        event.setGeneratorUrl(doc.getString((Object)"generatorUrl"));
        event.setPrometheusId(doc.getString((Object)"prometheusId"));
        event.setOtherLabelsString(doc.getString((Object)"otherLabelsString"));
        return event;
    }

    @Override
    public void cleanDB() {
        logger.info("MongoDbDataManager: cleanDB: started");
        try {
            long daysInMillis = Integer.toUnsignedLong(AmProps.ALERTMONITOR_DATA_RETENTION_DAYS) * 24L * 3600L * 1000L;
            long diff = System.currentTimeMillis() - daysInMillis;
            Bson filter = Filters.lte((String)"timestamp", (Object)diff);
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("webhook");
            DeleteResult resultDeleteMany = collection.deleteMany(filter);
            logger.info("MongoDbDataManager: cleanDB [webhook]: result" + resultDeleteMany);
            ((Counter.Child)AmMetrics.alertmonitor_db_deletes_total.labels(new String[]{"webhook"})).inc();
            MongoCollection collection2 = db.getCollection("journal");
            DeleteResult resultDeleteMany2 = collection2.deleteMany(filter);
            logger.info("MongoDbDataManager: cleanDB [journal]: result" + resultDeleteMany2);
            ((Counter.Child)AmMetrics.alertmonitor_db_deletes_total.labels(new String[]{"journal"})).inc();
            DAO.getInstance().removeWarning("mongo");
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: cleanDB: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
        }
    }

    @Override
    public void handleAlarmClearing(DEvent clearEvent) {
        try {
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            MongoCollection collection = db.getCollection("journal");
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"correlationId", (Object)clearEvent.getCorrelationId()), Filters.eq((String)"clearTimestamp", (Object)0)});
            Bson updateOperation1 = Updates.set((String)"clearTimestamp", (Object)clearEvent.getClearTimestamp());
            Bson updateOperation2 = Updates.set((String)"clearUid", (Object)clearEvent.getUid());
            Bson updates = Updates.combine((Bson[])new Bson[]{updateOperation1, updateOperation2});
            UpdateResult updateResult = collection.updateMany(filter, updates);
            logger.info("MongoDbDataManager: handleAlarmClearing: result" + updateResult);
            ((Counter.Child)AmMetrics.alertmonitor_db_updates_total.labels(new String[]{"journal"})).inc();
            DAO.getInstance().removeWarning("mongo");
        }
        catch (Exception e) {
            logger.error("MongoDbDataManager: handleAlarmClearing: Exception: " + e.getMessage());
            DAO.getInstance().addWarning("mongo", "No connection to DB");
            ((Counter.Child)AmMetrics.alertmonitor_db_failures_total.labels(new String[0])).inc();
        }
    }

    @Override
    public void close() {
        this.mongoClient.close();
    }
}

