/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PQueryMessage;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PQueryResult;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApi;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApiException;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;

@ManagedBean
@SessionScoped
public class UiQueryBean {
    private String query = "up";
    private String result;
    private List<PQueryResult> queryResult;
    private boolean queryRangeEnabled = false;
    private Date startDate;
    private Date endDate;
    private String step = "1m";

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public List<PQueryResult> getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(List<PQueryResult> queryResult) {
        this.queryResult = queryResult;
    }

    public boolean isQueryRangeEnabled() {
        return this.queryRangeEnabled;
    }

    public void setQueryRangeEnabled(boolean queryRangeEnabled) {
        this.queryRangeEnabled = queryRangeEnabled;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    @PostConstruct
    public void init() {
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String query = requestParameterMap.getOrDefault("q", null);
        if (query != null && query.length() > 0) {
            this.query = query;
        }
    }

    public void execute() {
        this.queryResult = null;
        this.result = null;
        if (this.queryRangeEnabled) {
            this.executeQueryRange();
        } else {
            this.executeQuery();
        }
    }

    public void executeQuery() {
        if (this.query.startsWith("time_of_max")) {
            this.doMySpecialFunction();
            return;
        }
        PrometheusApi api = new PrometheusApi();
        try {
            PQueryMessage msg = api.query(this.query);
            if (msg.getErrorType() != null) {
                this.result = msg.getErrorType() + ": " + msg.getError();
                LogFactory.getLogger().error("UiQueryBean: executeQuery: result: " + this.result);
                return;
            }
            this.queryResult = msg.getData().getResult();
            if (this.queryResult == null) {
                LogFactory.getLogger().error("UiQueryBean: executeQuery: result is null");
                this.result = "result is null";
                return;
            }
            LogFactory.getLogger().info("UiQueryBean: executeQuery: size: " + this.queryResult.size());
            for (PQueryResult r : this.queryResult) {
                LogFactory.getLogger().debug("UiQueryBean: executeQuery: " + r.toString());
            }
        }
        catch (PrometheusApiException e) {
            LogFactory.getLogger().error("UiQueryBean: failed executing query; root cause: " + e.getMessage());
            this.result = "failed to get result: " + e.getMessage();
        }
    }

    public void executeQueryRange() {
        if (this.startDate == null) {
            this.result = "start date is missing";
            return;
        }
        if (this.endDate == null) {
            this.result = "end date is missing";
            return;
        }
        if (this.step == null || this.step.length() == 0) {
            this.result = "step is missing";
            return;
        }
        PrometheusApi api = new PrometheusApi();
        try {
            long start = this.startDate.getTime() / 1000L;
            long end = this.endDate.getTime() / 1000L;
            PQueryMessage msg = api.queryRange(this.query, start, end, this.step);
            if (msg.getErrorType() != null) {
                this.result = msg.getErrorType() + ": " + msg.getError();
                LogFactory.getLogger().error("UiQueryBean: executeQueryRange: result: " + this.result);
                return;
            }
            this.queryResult = msg.getData().getResult();
            if (this.queryResult == null) {
                LogFactory.getLogger().error("UiQueryBean: executeQueryRange: result is null");
                this.result = "result is null";
                return;
            }
            LogFactory.getLogger().info("UiQueryBean: executeQueryRange: size: " + this.queryResult.size());
            for (PQueryResult r : this.queryResult) {
                LogFactory.getLogger().debug("UiQueryBean: executeQueryRange: " + r.toString());
            }
        }
        catch (PrometheusApiException e) {
            LogFactory.getLogger().error(e.getMessage() + e.getMessage());
            this.result = "failed to get result: " + e.getMessage();
        }
    }

    public String confTimeRange(String s) {
        if (this.startDate == null) {
            this.startDate = new Date();
        }
        if (this.endDate == null) {
            this.endDate = new Date();
        }
        if (s.equals("1h")) {
            this.startDate.setTime(System.currentTimeMillis() - 3600000L);
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "1m";
        } else if (s.equals("4h")) {
            this.startDate.setTime(System.currentTimeMillis() - 14400000L);
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "15m";
        } else if (s.equals("24h")) {
            this.startDate.setTime(System.currentTimeMillis() - 86400000L);
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "1h";
        } else if (s.equals("7d")) {
            this.startDate.setTime(System.currentTimeMillis() - 604800000L);
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "24h";
        } else if (s.equals("today")) {
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            this.startDate.setTime(c.getTimeInMillis());
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "15m";
        } else if (s.equals("yesterday")) {
            Calendar c1 = Calendar.getInstance();
            c1.set(5, c1.get(5) - 1);
            c1.set(11, 0);
            c1.set(12, 0);
            c1.set(13, 0);
            this.startDate.setTime(c1.getTimeInMillis());
            Calendar c2 = Calendar.getInstance();
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            this.endDate.setTime(c2.getTimeInMillis());
            this.step = "1h";
        } else if (s.equals("month")) {
            Calendar c = Calendar.getInstance();
            c.set(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            this.startDate.setTime(c.getTimeInMillis());
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "24h";
        } else if (s.equals("30d")) {
            Calendar c1 = Calendar.getInstance();
            c1.set(6, c1.get(6) - 30);
            c1.set(11, 0);
            c1.set(12, 0);
            c1.set(13, 0);
            this.startDate.setTime(c1.getTimeInMillis());
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "1d";
        } else if (s.equals("90d")) {
            Calendar c1 = Calendar.getInstance();
            c1.set(6, c1.get(6) - 90);
            c1.set(5, 1);
            c1.set(11, 0);
            c1.set(12, 0);
            c1.set(13, 0);
            this.startDate.setTime(c1.getTimeInMillis());
            this.endDate.setTime(System.currentTimeMillis());
            this.step = "1d";
        }
        return "";
    }

    public void doMySpecialFunction() {
        this.queryResult = null;
        this.result = null;
        PrometheusApi api = new PrometheusApi();
        try {
            String tempQuery = this.query.replace("time_of_max(", "");
            tempQuery = tempQuery.substring(0, tempQuery.length() - 1);
            LogFactory.getLogger().info("QUERY: " + tempQuery);
            PQueryMessage msg = api.query(tempQuery);
            if (msg.getErrorType() != null) {
                this.result = msg.getErrorType() + ": " + msg.getError();
                LogFactory.getLogger().error("doMySpecialFunction: result: " + this.result);
                return;
            }
            this.queryResult = msg.getData().getResult();
            if (this.queryResult == null) {
                LogFactory.getLogger().error("doMySpecialFunction: result is null");
                this.result = "result is null";
                return;
            }
            for (PQueryResult r : this.queryResult) {
                double maxVal = 0.0;
                for (Object[] oArray : r.getValues()) {
                    double d = Double.parseDouble(oArray[1].toString());
                    if (!(d > maxVal)) continue;
                    maxVal = d;
                }
                Iterator<Object[]> it = r.getValues().iterator();
                while (it.hasNext()) {
                    double d = Double.parseDouble(it.next()[1].toString());
                    if (!(d < maxVal)) continue;
                    it.remove();
                }
                r.getMetric().put("__name__", "time_of_max(" + r.getMetric().get("__name__") + ")");
            }
        }
        catch (PrometheusApiException e) {
            LogFactory.getLogger().error(e.getMessage(), (Throwable)e);
            this.result = "failed to get result: " + e.getMessage();
        }
    }

    public String toNormalDate(Object d) {
        try {
            Double dts = Double.parseDouble(d.toString()) * 1000.0;
            return Formatter.getFormatedTimestamp(dts.longValue());
        }
        catch (Exception e) {
            LogFactory.getLogger().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

