/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.alertmanager.AlertmanagerProcessor;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;

public class WebhookServlet
extends HttpServlet {
    private static final long serialVersionUID = 4274913262329715396L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405, "GET method not allowed");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        WebhookMessage m = this.instantiateWebhookMessage(req);
        try {
            AlertmanagerProcessor.processWebhookMessage(m);
            ++AmMetrics.amMessagesReceivedCount;
            AmMetrics.lastEventTimestamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            LogFactory.getLogger().error("WebhookServlet: doPost(): failed to process webhook message(): " + e.getMessage());
            LogFactory.getLogger().info("Failed message: \n" + m.toString());
        }
    }

    private WebhookMessage instantiateWebhookMessage(HttpServletRequest req) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("protocol=").append(req.getProtocol()).append(", ");
        sb.append("remoteAddr=").append(req.getRemoteAddr()).append(", ");
        sb.append("remoteHost=").append(req.getRemoteHost()).append(", ");
        sb.append("remotePort=").append(req.getRemotePort()).append(", ");
        sb.append("method=").append(req.getMethod()).append(", ");
        sb.append("requestURI=").append(req.getRequestURI()).append(", ");
        sb.append("scheme=").append(req.getScheme()).append(", ");
        sb.append("characterEncoding=").append(req.getCharacterEncoding()).append(", ");
        sb.append("contentLength=").append(req.getContentLength()).append(", ");
        sb.append("contentType=").append(req.getContentType());
        sb.append("}");
        LogFactory.getLogger().info("WebhookServlet: instantiateWebhookMessage(): " + sb.toString());
        LogFactory.getLogger().debug("WebhookServlet: instantiateWebhookMessage(): parameterMap: " + this.getReqParamsAsString(req));
        LogFactory.getLogger().debug("WebhookServlet: instantiateWebhookMessage(): headers: " + this.getReqHeadersAsString(req));
        String body = this.getReqBody(req);
        LogFactory.getLogger().debug("WebhookServlet: instantiateWebhookMessage(): body: " + body);
        WebhookMessage m = new WebhookMessage();
        m.setId(AmMetrics.webhookMessagesReceivedCount);
        m.setRuntimeId(AmProps.ALERTMONITOR_RUNTIME_ID);
        m.setTimestamp(System.currentTimeMillis());
        m.setContentLength(req.getContentLength());
        m.setContentType(req.getContentType());
        m.setMethod(req.getMethod());
        m.setProtocol(req.getProtocol());
        m.setRemoteHost(req.getRemoteHost());
        m.setRemotePort(req.getRemotePort());
        m.setRequestUri(req.getRequestURI());
        m.setBody(body);
        m.setHeaderMap(this.generateHeaderMap(req));
        m.setParameterMap(this.generateParamMap(req));
        DAO.getInstance().addWebhookMessage(m);
        return m;
    }

    private Map<String, String> generateHeaderMap(HttpServletRequest req) {
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String val = req.getHeader(key);
            m.put(key, val);
        }
        return m;
    }

    private Map<String, String> generateParamMap(HttpServletRequest req) {
        HashMap<String, String> m = new HashMap<String, String>();
        Map parameterMap = req.getParameterMap();
        for (String s : parameterMap.keySet()) {
            m.put(s, ((String[])parameterMap.get(s))[0]);
        }
        return m;
    }

    private String getReqHeadersAsString(HttpServletRequest req) {
        String headers = "";
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String val = req.getHeader(key);
            headers = headers + key + "=" + val + ", ";
        }
        return headers;
    }

    private String getReqParamsAsString(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        String params = "";
        for (String s : parameterMap.keySet()) {
            params = params + s + "=" + ((String[])parameterMap.get(s))[0] + ", ";
        }
        return params;
    }

    private String getReqBody(HttpServletRequest req) throws IOException {
        if (req.getMethod().equalsIgnoreCase("get")) {
            return req.getPathInfo() + " " + this.generateParamMap(req);
        }
        String body = "";
        String s = req.getReader().readLine();
        while (s != null) {
            body = body + s;
            s = req.getReader().readLine();
        }
        return body;
    }
}

