/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.simplelogger;

import java.util.Map;
import java.util.Properties;

public class Config {
    private boolean append = true;
    private int logLevel = 3;
    private String dateFormat = "yyyy.MM.dd hh:mm:ss:SSS";
    private String filename = "./simple-logger.log";
    private int maxSizeMb = 10;
    private int backup = 5;
    private boolean verbose = true;
    public static final String PROP_FILENAME = "simplelogger.filename";
    public static final String PROP_LEVEL = "simplelogger.level";
    public static final String PROP_APPEND = "simplelogger.append";
    public static final String PROP_VERBOSE = "simplelogger.verbose";
    public static final String PROP_MAX_FILE_SIZE = "simplelogger.maxFileSize";
    public static final String PROP_MAX_BACKUP_FILES = "simplelogger.maxBackupFiles";
    public static final String PROP_DATE_FORMAT = "simplelogger.dateFormat";
    public static final String ENV_FILENAME = "SIMPLELOGGER_FILENAME";
    public static final String ENV_LEVEL = "SIMPLELOGGER_LEVEL";
    public static final String ENV_APPEND = "SIMPLELOGGER_APPEND";
    public static final String ENV_VERBOSE = "SIMPLELOGGER_VERBOSE";
    public static final String ENV_MAX_FILE_SIZE = "SIMPLELOGGER_MAXFILESIZE";
    public static final String ENV_MAX_BACKUP_FILES = "SIMPLELOGGER_MAXBACKUPFILES";
    public static final String ENV_DATE_FORMAT = "SIMPLELOGGER_DATEFORMAT";

    public Config() {
        Map<String, String> map = System.getenv();
        this.filename = map.getOrDefault(ENV_FILENAME, "./simple-logger.log");
        String level = map.getOrDefault(ENV_LEVEL, "info");
        this.setLogLevel(level);
        this.append = map.getOrDefault(ENV_APPEND, "true").equalsIgnoreCase("true");
        this.verbose = map.getOrDefault(ENV_VERBOSE, "true").equalsIgnoreCase("true");
        try {
            this.maxSizeMb = Integer.parseInt(map.getOrDefault(ENV_MAX_FILE_SIZE, "10"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.backup = Integer.parseInt(map.getOrDefault(ENV_MAX_BACKUP_FILES, "5"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.dateFormat = map.getOrDefault(ENV_DATE_FORMAT, "yyyy.MM.dd hh:mm:ss:SSS");
    }

    public void loadProperties(Properties props) {
        this.filename = props.getProperty(PROP_FILENAME, "./simple-logger.log");
        String level = props.getProperty(PROP_LEVEL, "info");
        this.setLogLevel(level);
        this.append = props.getProperty(PROP_APPEND, "true").equalsIgnoreCase("true");
        this.verbose = props.getProperty(PROP_VERBOSE, "true").equalsIgnoreCase("true");
        try {
            this.maxSizeMb = Integer.parseInt(props.getProperty(PROP_MAX_FILE_SIZE, "10"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.backup = Integer.parseInt(props.getProperty(PROP_MAX_BACKUP_FILES, "5"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.dateFormat = props.getProperty(PROP_DATE_FORMAT, "yyyy.MM.dd hh:mm:ss:SSS");
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getMaxSizeMb() {
        return this.maxSizeMb;
    }

    public void setMaxSizeMb(int maxSizeMb) {
        this.maxSizeMb = maxSizeMb;
    }

    public int getBackup() {
        return this.backup;
    }

    public void setBackup(int backup) {
        this.backup = backup;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void setLogLevel(String level) {
        this.logLevel = level.equalsIgnoreCase("trace") ? 1 : (level.equalsIgnoreCase("debug") ? 2 : (level.equalsIgnoreCase("info") ? 3 : (level.equalsIgnoreCase("warn") ? 4 : (level.equalsIgnoreCase("error") ? 5 : (level.equalsIgnoreCase("fatal") ? 6 : 3)))));
    }

    public String toString() {
        return "[append=" + this.append + ", logLevel=" + this.logLevel + ", dateFormat='" + this.dateFormat + ", filename='" + this.filename + ", maxSizeMb=" + this.maxSizeMb + ", backup=" + this.backup + ", verbose=" + this.verbose + "]";
    }
}

