/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.DTag;
import si.matjazcerkvenik.alertmonitor.model.TagColors;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.Growl;

@ManagedBean
@RequestScoped
public class UiAlertBean {
    private DEvent event;

    @PostConstruct
    public void init() {
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String uid = requestParameterMap.getOrDefault("uid", "null");
        this.event = DAO.getInstance().getEvent(uid);
        if (this.event == null) {
            Growl.showWarningGrowl("Object not found", null);
            LogFactory.getLogger().info("UiAlertBean: object not found: uid=" + uid);
        }
    }

    public DEvent getEvent() {
        return this.event;
    }

    public DTag getTagObject(String severity) {
        return new DTag(severity, TagColors.getColor(severity));
    }

    public String getAge() {
        int secUpTotal = 0;
        secUpTotal = this.event.getClearTimestamp() == 0L ? (int)((System.currentTimeMillis() - this.event.getFirstTimestamp()) / 1000L) : (int)((this.event.getClearTimestamp() - this.event.getFirstTimestamp()) / 1000L);
        return Formatter.convertToDHMSFormat(secUpTotal);
    }
}

