/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.util;

import io.prometheus.client.Gauge;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.util.TaskManager;

public class OnStartListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        AmProps.startUpTime = System.currentTimeMillis();
        InputStream inputStream = servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/version.txt");
        try {
            DataInputStream dis = new DataInputStream(inputStream);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            AmProps.version = br.readLine().trim();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            AmProps.localIpAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            AmProps.localIpAddress = "UnknownHost";
        }
        LogFactory.getLogger().info("\n");
        LogFactory.getLogger().info("************************************************");
        LogFactory.getLogger().info("*                                              *");
        LogFactory.getLogger().info("*             Alertmonitor started             *");
        LogFactory.getLogger().info("*                                              *");
        LogFactory.getLogger().info("************************************************");
        LogFactory.getLogger().info("");
        LogFactory.getLogger().info("ALERTMONITOR_VERSION=" + AmProps.version);
        LogFactory.getLogger().info("ALERTMONITOR_IPADDR=" + AmProps.localIpAddress);
        AmProps.ALERTMONITOR_RUNTIME_ID = UUID.randomUUID().toString();
        LogFactory.getLogger().info("RUNTIME_ID=" + AmProps.ALERTMONITOR_RUNTIME_ID);
        LogFactory.getLogger().info("***** Environment variables *****");
        Map<String, String> map = System.getenv();
        for (Map.Entry entry : map.entrySet()) {
            LogFactory.getLogger().info((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        AmProps.ALERTMONITOR_DATA_RETENTION_DAYS = Integer.parseInt(System.getenv().getOrDefault("ALERTMONITOR_DATA_RETENTION_DAYS", "30").trim());
        AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC = Integer.parseInt(System.getenv().getOrDefault("ALERTMONITOR_PSYNC_INTERVAL_SEC", "60").trim());
        if (AmProps.ALERTMONITOR_PROMETHEUS_SERVER.endsWith("/")) {
            AmProps.ALERTMONITOR_PROMETHEUS_SERVER = AmProps.ALERTMONITOR_PROMETHEUS_SERVER.substring(0, AmProps.ALERTMONITOR_PROMETHEUS_SERVER.length() - 1);
        }
        if ((AmProps.ALERTMONITOR_PROMETHEUS_SERVER = System.getenv().getOrDefault("ALERTMONITOR_PROMETHEUS_SERVER", "http://localhost:9090").trim()).endsWith("/")) {
            AmProps.ALERTMONITOR_PROMETHEUS_SERVER = AmProps.ALERTMONITOR_PROMETHEUS_SERVER.substring(0, AmProps.ALERTMONITOR_PROMETHEUS_SERVER.length() - 1);
        }
        if (!AmProps.ALERTMONITOR_PROMETHEUS_SERVER.startsWith("http")) {
            AmProps.ALERTMONITOR_PROMETHEUS_SERVER = "http://" + AmProps.ALERTMONITOR_PROMETHEUS_SERVER;
        }
        AmProps.ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC = Integer.parseInt(System.getenv().getOrDefault("ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC", "120").trim());
        AmProps.ALERTMONITOR_DATE_FORMAT = System.getenv().getOrDefault("ALERTMONITOR_DATE_FORMAT", "yyyy/MM/dd H:mm:ss").trim();
        AmProps.ALERTMONITOR_KAFKA_ENABLED = Boolean.parseBoolean(System.getenv().getOrDefault("ALERTMONITOR_KAFKA_ENABLED", "false").trim());
        AmProps.ALERTMONITOR_KAFKA_SERVER = System.getenv().getOrDefault("ALERTMONITOR_KAFKA_SERVER", "localhost:9092").trim();
        AmProps.ALERTMONITOR_KAFKA_TOPIC = System.getenv().getOrDefault("ALERTMONITOR_KAFKA_TOPIC", "alertmonitor_events").trim();
        AmProps.ALERTMONITOR_PROMETHEUS_ID_LABELS = System.getenv().getOrDefault("ALERTMONITOR_PROMETHEUS_ID_LABELS", "cluster, region, monitor").trim();
        AmProps.ALERTMONITOR_MONGODB_ENABLED = Boolean.parseBoolean(System.getenv().getOrDefault("ALERTMONITOR_MONGODB_ENABLED", "true").trim());
        AmProps.ALERTMONITOR_MONGODB_CONNECTION_STRING = System.getenv().getOrDefault("ALERTMONITOR_MONGODB_CONNECTION_STRING", "mongodb://admin:mongodbpassword@promvm:27017/?authSource=admin").trim();
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        LogFactory.getLogger().info("***** Heap utilization statistics [MB] *****");
        LogFactory.getLogger().info("Total Memory: " + runtime.totalMemory() / (long)mb);
        LogFactory.getLogger().info("Free Memory: " + runtime.freeMemory() / (long)mb);
        LogFactory.getLogger().info("Used Memory: " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        LogFactory.getLogger().info("Max Memory: " + runtime.maxMemory() / (long)mb);
        try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
            LogFactory.getLogger().info("Running in container: " + stream.anyMatch(line -> line.contains("/docker")));
            AmProps.isContainerized = true;
        }
        catch (IOException e) {
            LogFactory.getLogger().info("Running in container: false");
            AmProps.isContainerized = false;
        }
        ((Gauge.Child)AmMetrics.alertmonitor_build_info.labels(new String[]{"Alertmonitor", AmProps.ALERTMONITOR_RUNTIME_ID, AmProps.version, System.getProperty("os.name")})).set((double)AmProps.startUpTime);
        TaskManager.getInstance().restartPsyncTimer();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        TaskManager.getInstance().stopPsyncTimer();
        LogFactory.getLogger().info("#");
        LogFactory.getLogger().info("# Stopping Alertmonitor");
        LogFactory.getLogger().info("#\n\n\n");
        LogFactory.getLogger().close();
    }
}

