/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.Target;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;

@ManagedBean
@ViewScoped
public class UiInstanceBean {
    private Target target;

    @PostConstruct
    public void init() {
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String id = requestParameterMap.getOrDefault("tid", "null");
        this.target = DAO.getInstance().getSingleTarget(id);
        LogFactory.getLogger().info("Found target: " + this.target.toString());
    }

    public Target getTarget() {
        return this.target;
    }

    public List<DEvent> getInstanceActiveAlarms() {
        ArrayList<DEvent> list = new ArrayList<DEvent>(DAO.getInstance().getActiveAlerts().values());
        List<DEvent> result = list.stream().filter(notif -> this.checkAlert((DEvent)notif)).collect(Collectors.toList());
        Collections.sort(result, new Comparator<DEvent>(){

            @Override
            public int compare(DEvent lhs, DEvent rhs) {
                return lhs.getTimestamp() > rhs.getTimestamp() ? -1 : (lhs.getTimestamp() < rhs.getTimestamp() ? 1 : 0);
            }
        });
        return result;
    }

    public List<DEvent> getInstanceJournalAlarms() {
        List<DEvent> result = DAO.getInstance().getJournal().stream().filter(notif -> this.checkAlert((DEvent)notif)).collect(Collectors.toList());
        Collections.sort(result, new Comparator<DEvent>(){

            @Override
            public int compare(DEvent lhs, DEvent rhs) {
                return lhs.getTimestamp() > rhs.getTimestamp() ? -1 : (lhs.getTimestamp() < rhs.getTimestamp() ? 1 : 0);
            }
        });
        return result;
    }

    private boolean checkAlert(DEvent n) {
        return this.target.isSmartTarget() ? n.getHostname().equals(this.target.getHostname()) : n.getInstance().equals(this.target.getHostname());
    }

    public String getTargetType() {
        if (this.target.isSmartTarget()) {
            return "SmartTarget";
        }
        return "Instance";
    }

    public String getUpStatus() {
        if (this.target.isUp()) {
            return "Up";
        }
        return "Down";
    }

    public String getUpStatusSeverity() {
        if (this.target.isUp()) {
            return "success";
        }
        return "danger";
    }

    public String getUpStatusTooltip() {
        if (this.target.isUp()) {
            return "At least one job is up";
        }
        return "All jobs are down";
    }
}

