/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.support.Endpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ConfigModifier {
    private List<ScrapeEndpoint> scrapes = new ArrayList<ScrapeEndpoint>();
    private Consumer<ConfigModifier> endAction;

    public ConfigModifier() {
    }

    public ConfigModifier(List<ScrapeEndpoint> endpoints, Consumer<ConfigModifier> endAction) {
        this.endAction = endAction;
        this.scrapes.addAll(endpoints);
    }

    public void addScrapeEndpoint(ScrapeEndpoint entry) {
        this.scrapes.add(entry);
    }

    public Iterable<ScrapeEndpoint> scrapeEndpoints() {
        return this.scrapes;
    }

    public void end() {
        if (null != this.endAction) {
            this.endAction.accept(this);
            this.endAction = null;
        }
    }

    public static class ScrapeEndpoint {
        private String name;
        private Endpoint scrapePoint;

        public ScrapeEndpoint(String name, Endpoint scrapePoint) {
            this.name = name;
            this.scrapePoint = scrapePoint;
        }

        public String getName() {
            return this.name;
        }

        public Endpoint getScrapePoint() {
            return this.scrapePoint;
        }
    }
}

