/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.DTag;
import si.matjazcerkvenik.alertmonitor.model.Job;
import si.matjazcerkvenik.alertmonitor.model.Target;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.Growl;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;

@ManagedBean
@SessionScoped
public class UiBean {
    private List<DTag> tagList = new ArrayList<DTag>();
    private String searchString;
    private boolean smartTargetsEnabled = true;
    private String result;

    public void addMessage() {
        Growl.showInfoGrowl("Configuration updated", "");
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        LogFactory.getLogger().info("SEARCH: " + searchString);
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public List<WebhookMessage> getWebhookMessages() {
        return DAO.getInstance().getWebhookMessages();
    }

    public List<DEvent> getJournal() {
        return DAO.getInstance().getJournal();
    }

    public List<DEvent> getActiveAlarms() {
        ArrayList<DEvent> list = new ArrayList<DEvent>(DAO.getInstance().getActiveAlerts().values());
        List<DEvent> result = list.stream().filter(notif -> this.filterNotification((DEvent)notif)).collect(Collectors.toList());
        return result;
    }

    private boolean filterNotification(DEvent notif) {
        if (!(this.searchString == null || this.searchString.length() <= 0 || notif.getInstance().toLowerCase().contains(this.searchString.toLowerCase()) || notif.getAlertname().toLowerCase().contains(this.searchString.toLowerCase()) || notif.getInfo().toLowerCase().contains(this.searchString.toLowerCase()) || notif.getJob().toLowerCase().contains(this.searchString.toLowerCase()) || notif.getDescription().toLowerCase().contains(this.searchString.toLowerCase()))) {
            return false;
        }
        String[] array = notif.getTags().split(",");
        for (int i = 0; i < array.length; ++i) {
            String tagName = array[i].trim();
            for (DTag t : this.tagList) {
                if (t.getName().equals(tagName) && t.isSelected()) {
                    return true;
                }
                if (t.getName().equals(notif.getSeverity()) && t.isSelected()) {
                    return true;
                }
                if (!t.getName().equals(notif.getPriority()) || !t.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public List<DTag> getTags() {
        boolean found;
        List<DTag> daoTagList = DAO.getInstance().getTags();
        for (DTag dt : daoTagList) {
            found = false;
            for (DTag t : this.tagList) {
                if (!t.getName().equals(dt.getName())) continue;
                found = true;
            }
            if (found) continue;
            if (this.getNumberOfSelectedTags() == this.tagList.size()) {
                dt.setSelected(true);
            } else {
                dt.setSelected(false);
            }
            this.tagList.add(dt);
        }
        Iterator<DTag> it = this.tagList.iterator();
        while (it.hasNext()) {
            DTag t = it.next();
            found = false;
            for (DTag dt : daoTagList) {
                if (!dt.getName().equals(t.getName())) continue;
                found = true;
            }
            if (found) continue;
            it.remove();
        }
        return this.tagList;
    }

    public void tagAction(DTag tag) {
        LogFactory.getLogger().debug("tag action called: " + tag.getName());
        int numberOfSelectedTags = this.getNumberOfSelectedTags();
        LogFactory.getLogger().debug("numberOfSelectedTags: " + numberOfSelectedTags + "/" + this.tagList.size());
        if (numberOfSelectedTags == this.tagList.size()) {
            for (DTag t : this.tagList) {
                if (t.getName().equals(tag.getName())) {
                    t.setSelected(true);
                    continue;
                }
                t.setSelected(false);
            }
            return;
        }
        if (numberOfSelectedTags == 1) {
            DTag theOnlySelectedTag = null;
            for (DTag t : this.tagList) {
                if (!t.isSelected()) continue;
                theOnlySelectedTag = t;
                break;
            }
            if (theOnlySelectedTag.getName().equals(tag.getName())) {
                for (DTag t : this.tagList) {
                    t.setSelected(true);
                }
            } else {
                for (DTag t : this.tagList) {
                    if (!t.getName().equals(tag.getName())) continue;
                    t.setSelected(true);
                }
            }
            return;
        }
        if (numberOfSelectedTags > 0) {
            Object selectedTag = null;
            for (DTag t : this.tagList) {
                if (!t.getName().equals(tag.getName())) continue;
                t.setSelected(!t.isSelected());
                break;
            }
        }
    }

    private int getNumberOfSelectedTags() {
        int numberOfSelectedTags = 0;
        for (DTag t : this.tagList) {
            if (!t.isSelected()) continue;
            ++numberOfSelectedTags;
        }
        return numberOfSelectedTags;
    }

    public boolean isSmartTargetsEnabled() {
        return this.smartTargetsEnabled;
    }

    public void setSmartTargetsEnabled(boolean smartTargetsEnabled) {
        this.smartTargetsEnabled = smartTargetsEnabled;
    }

    public List<Target> getTargets() {
        this.result = null;
        List<Target> tList = this.smartTargetsEnabled ? DAO.getInstance().getSmartTargets() : DAO.getInstance().getTargets();
        if (tList == null) {
            this.result = "failed to retrieve targets";
            return new ArrayList<Target>();
        }
        return tList.stream().filter(target -> this.filterTarget((Target)target)).collect(Collectors.toList());
    }

    private boolean filterTarget(Target target) {
        return this.searchString == null || this.searchString.length() <= 0 || target.getHostname().toLowerCase().contains(this.searchString.toLowerCase());
    }

    public String getTargetHighestPriorityBullet(Target target) {
        int critical = 0;
        int major = 0;
        int minor = 0;
        int warning = 0;
        int informational = 0;
        int indeterminate = 0;
        for (DEvent n : target.getAlerts()) {
            if (n.getSeverity().equalsIgnoreCase("critical")) {
                ++critical;
            }
            if (n.getSeverity().equalsIgnoreCase("major")) {
                ++major;
            }
            if (n.getSeverity().equalsIgnoreCase("minor")) {
                ++minor;
            }
            if (n.getSeverity().equalsIgnoreCase("warning")) {
                ++warning;
            }
            if (n.getSeverity().equalsIgnoreCase("informational")) {
                ++informational;
            }
            if (!n.getSeverity().equalsIgnoreCase("indeterminate")) continue;
            ++indeterminate;
        }
        if (critical > 0) {
            return "bullet_red";
        }
        if (major > 0) {
            return "bullet_orange";
        }
        if (minor > 0) {
            return "bullet_orange";
        }
        if (warning > 0) {
            return "bullet_yellow";
        }
        if (informational > 0) {
            return "bullet_blue";
        }
        if (indeterminate > 0) {
            return "bullet_purple";
        }
        return "bullet_green";
    }

    public List<Job> getJobs() {
        this.result = null;
        List<Target> tList = DAO.getInstance().getTargets();
        if (tList == null) {
            this.result = "failed to retrieve jobs";
            return new ArrayList<Job>();
        }
        HashMap<String, Job> jMap = new HashMap<String, Job>();
        for (Target t : tList) {
            Job job = jMap.getOrDefault(t.getJob(), new Job());
            job.setJobName(t.getJob());
            job.getTargetList().add(t);
            jMap.put(job.getJobName(), job);
        }
        return new ArrayList<Job>(jMap.values());
    }
}

