/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.monitoring.MonitoringSetup;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import java.io.IOException;

public class PrometheusMonitoringSetup
extends MonitoringSetup {
    public static final String DEFAULT_PROMETHEUS_SERVER = "localhost";
    public static final int DEFAULT_PROMETHEUSSERVER_PORT = 9090;
    public static final int DEFAULT_ALERTMGR_PORT = 9093;
    private static PrometheusMonitoringSetup instance;
    private PrometheusSetup prometheus = new PrometheusSetup();

    public PrometheusSetup getPrometheus() {
        return this.prometheus;
    }

    public void setPrometheus(PrometheusSetup prometheus) {
        this.prometheus = prometheus;
    }

    public static PrometheusMonitoringSetup readConfiguration() throws IOException {
        return (PrometheusMonitoringSetup)((Object)PrometheusMonitoringSetup.readFromYaml(PrometheusMonitoringSetup.class));
    }

    public static PrometheusMonitoringSetup getInstance() {
        if (null == instance) {
            try {
                instance = PrometheusMonitoringSetup.readConfiguration();
            }
            catch (IOException e) {
                instance = new PrometheusMonitoringSetup();
            }
        }
        return instance;
    }

    public static class PrometheusSetup {
        private ServerAddressHolder server = new ServerAddressHolder(Schema.HTTP, "localhost", 9090);
        private ServerAddressHolder exporter = new ServerAddressHolder(Schema.HTTP, "localhost", -1);
        private ServerAddressHolder alertMgr = new ServerAddressHolder(Schema.HTTP, "localhost", 9093);
        private int scrapeInterval = 1000;
        private int scrapeTimeout = 1000;
        private int evaluationInterval = 3000;

        public ServerAddressHolder getServer() {
            return this.server;
        }

        public void setServer(ServerAddressHolder server) {
            this.server = server;
        }

        public int getScrapeInterval() {
            return this.scrapeInterval;
        }

        public void setScrapeInterval(int scrapeInterval) {
            this.scrapeInterval = scrapeInterval;
        }

        public int getEvaluationInterval() {
            return this.evaluationInterval;
        }

        public void setEvaluationInterval(int evaluationInterval) {
            this.evaluationInterval = evaluationInterval;
        }

        public int getScrapeTimeout() {
            return this.scrapeTimeout;
        }

        public int getScrapeTimeoutSafe() {
            return this.scrapeTimeout > this.scrapeInterval ? this.scrapeInterval : this.scrapeTimeout;
        }

        public void setScrapeTimeout(int scrapeTimeout) {
            this.scrapeTimeout = scrapeTimeout;
        }

        public ServerAddressHolder getExporter() {
            return this.exporter;
        }

        public void setExporter(ServerAddressHolder exporter) {
            this.exporter = exporter;
        }

        public ServerAddressHolder getAlertMgr() {
            return this.alertMgr;
        }

        public void setAlertMgr(ServerAddressHolder alertMgr) {
            this.alertMgr = alertMgr;
        }
    }
}

