/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.monitoring.MonitoringReceiver;
import de.iip_ecosphere.platform.monitoring.MonitoringSetup;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.util.HashSet;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.monitoring.AbstractMonitoringReceiverTest;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class MonitoringReceiverTest
extends AbstractMonitoringReceiverTest {
    protected static Server qpid;

    @BeforeClass
    public static void setup() {
        TestWithQpid.addPlugin();
        TestWithQpid.loadPlugins();
    }

    @AfterClass
    public static void stop() {
        Server.stop((Server)qpid, (boolean)true);
    }

    @Override
    protected Server createBroker(ServerAddress broker) {
        if (null == qpid) {
            qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        }
        return qpid;
    }

    @Test
    public void testReceiver() {
        MyMonitoringReceiverLifecycle mrl = new MyMonitoringReceiverLifecycle();
        this.runScenario(mrl);
        mrl.getInstance().doAsserts();
    }

    @Override
    protected int getSleepTime() {
        return 8000;
    }

    protected class MyMonitoringReceiverLifecycle
    implements AbstractMonitoringReceiverTest.MonitoringRecieverLifecycle {
        private MyReceiver receiver;

        protected MyMonitoringReceiverLifecycle() {
        }

        @Override
        public void start(TransportSetup transSetup) {
            MonitoringSetup.getInstance().setTransport(transSetup);
            this.receiver = new MyReceiver();
            this.receiver.start();
        }

        @Override
        public void stop() {
            this.receiver.stop();
        }

        protected MyReceiver getInstance() {
            return this.receiver;
        }
    }

    protected class MyReceiver
    extends MonitoringReceiver {
        private String createdExporterId;
        private Set<String> receivedMeterStreams = new HashSet<String>();
        private int statusCount;
        private int meterRecCount;
        private int meterCount;
        private int meterCount2;

        protected MyReceiver() {
        }

        protected MonitoringReceiver.Exporter createExporter(String id) {
            return new MyExporter(id);
        }

        protected void notifyMeterReception(String stream, String id, JsonObject obj) {
            this.receivedMeterStreams.add(stream);
            ++this.meterRecCount;
        }

        protected void notifyStatusReceived(StatusMessage msg) {
            ++this.statusCount;
        }

        protected void notifyMeterAdded(Meter meter) {
            if (meter != null) {
                ++this.meterCount2;
            }
        }

        protected void doAsserts() {
            String deviceId = Id.getDeviceId();
            Assert.assertEquals((Object)deviceId, (Object)this.createdExporterId);
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("EcsMetrics"));
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("ServiceMetrics"));
            Assert.assertTrue((this.statusCount >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterRecCount > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterCount > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterCount2 > 0 ? 1 : 0) != 0);
        }

        private class MyExporter
        extends MonitoringReceiver.Exporter {
            protected MyExporter(String id) {
                super((MonitoringReceiver)MyReceiver.this, id);
                MyReceiver.this.createdExporterId = id;
            }

            protected void initialize() {
            }

            protected void addMeter(Meter meter) {
                if (meter != null) {
                    ++MyReceiver.this.meterCount;
                }
            }
        }
    }
}

