/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MonitoringReceiver {
    private Map<String, Exporter> registry = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exporter obtainExporter(String id) {
        Exporter exporter;
        boolean isNew = false;
        MonitoringReceiver monitoringReceiver = this;
        synchronized (monitoringReceiver) {
            exporter = this.registry.get(id);
            if (null == exporter) {
                exporter = this.createExporter(id);
                this.registry.put(id, exporter);
                isNew = true;
            }
        }
        if (isNew) {
            exporter.initialize();
            this.notifyExporterAdded(exporter);
        }
        return exporter;
    }

    protected abstract Exporter createExporter(String var1);

    protected void notifyMeterReception(String stream, String id, JsonObject obj) {
    }

    protected void notifyStatusReceived(StatusMessage msg) {
    }

    protected void notifyMeterAdded(Meter meter) {
    }

    protected void notifyExporterAdded(Exporter exporter) {
    }

    protected void notifyExporterRemoved(Exporter exporter) {
    }

    public void start() {
        LoggerFactory.getLogger(MonitoringReceiver.class).info("Connecting to IIP-Ecosphere transport");
        TransportConnector conn = Transport.createConnector();
        if (null == conn) {
            LoggerFactory.getLogger(MonitoringReceiver.class).warn("No IIP-Ecosphere transport connector available. Central monitoring disabled");
        } else {
            try {
                conn.setReceptionCallback("ComponentStatus", (ReceptionCallback)new StatusReceptionCallback());
                conn.setReceptionCallback("EcsMetrics", (ReceptionCallback)new MeterReceptionCallback("EcsMetrics"));
                conn.setReceptionCallback("ServiceMetrics", (ReceptionCallback)new MeterReceptionCallback("ServiceMetrics"));
            }
            catch (IOException e) {
                conn = null;
                LoggerFactory.getLogger(MonitoringReceiver.class).warn("Cannot connect to IIP-Ecosphere transport: {} Central monitoring disabled", (Object)e.getMessage());
            }
        }
    }

    public void stop() {
    }

    public Iterable<Exporter> exporters() {
        return this.registry.values();
    }

    protected abstract class Exporter {
        private String id;
        private boolean valid;

        protected Exporter(String id) {
            this.id = id;
        }

        protected abstract void initialize();

        protected void addMeters(String deviceId, JsonObject mtrs) {
            for (String k : mtrs.keys()) {
                Meter meter = MeterRepresentation.parseMeter((String)mtrs.getValue(k).toString(), (String[])new String[]{"device:" + deviceId});
                if (null == meter) continue;
                this.addMeter(meter);
                MonitoringReceiver.this.notifyMeterAdded(meter);
            }
        }

        protected abstract void addMeter(Meter var1);

        protected String getId() {
            return this.id;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected void dispose() {
            this.valid = false;
        }

        protected void validate() {
            this.valid = true;
        }
    }

    private class StatusReceptionCallback
    implements ReceptionCallback<StatusMessage> {
        private StatusReceptionCallback() {
        }

        public void received(StatusMessage msg) {
            MonitoringReceiver.this.notifyStatusReceived(msg);
            String id = msg.getDeviceId();
            if (ActionTypes.REMOVED == msg.getAction() && ComponentTypes.DEVICE == msg.getComponentType()) {
                Exporter exporter = MonitoringReceiver.this.registry.remove(id);
                if (null != exporter) {
                    exporter.dispose();
                    MonitoringReceiver.this.notifyExporterRemoved(exporter);
                }
            } else {
                MonitoringReceiver.this.obtainExporter(id).validate();
            }
        }

        public Class<StatusMessage> getType() {
            return StatusMessage.class;
        }
    }

    private class MeterReceptionCallback
    implements ReceptionCallback<String> {
        private String stream;

        private MeterReceptionCallback(String stream) {
            this.stream = stream;
        }

        public void received(String data) {
            try {
                try {
                    JsonObject obj = Json.createObject((String)data);
                    String id = obj.getString("id");
                    MonitoringReceiver.this.notifyMeterReception(this.stream, id, obj);
                    if (null != id) {
                        MonitoringReceiver.this.obtainExporter(id).addMeters(id, obj.getJsonObject("meters"));
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(MonitoringReceiver.class).error("Cannot parse JSON: " + e.getMessage() + " " + data);
                }
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(MonitoringReceiver.class).warn("Cannot parse received meter data '{}' on {}: {}", new Object[]{data, this.stream, e.getMessage()});
            }
        }

        public Class<String> getType() {
            return String.class;
        }
    }
}

