/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.http.Http;
import de.iip_ecosphere.platform.support.http.HttpClient;
import de.iip_ecosphere.platform.support.http.HttpPost;
import de.iip_ecosphere.platform.support.http.HttpRequest;
import de.iip_ecosphere.platform.support.http.HttpResponse;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractRestProcessService<I, O>
extends AbstractProcessService<I, String, String, O> {
    private HttpURLConnection connection;
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private HttpClient client;

    protected AbstractRestProcessService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService yaml) {
        super(inTrans, outTrans, callback, yaml);
    }

    protected abstract String getApiPath();

    protected HttpURLConnection getConnection() {
        return this.connection;
    }

    protected abstract String getBearerToken();

    protected HttpURLConnection getNewConnectionInstance() throws IOException {
        try {
            URL url = NetUtils.createURL((String)this.getApiPath());
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("Content-Type", "application/json");
            String bearer = this.getBearerToken();
            if (null != bearer) {
                this.connection.setRequestProperty("Authorization", bearer);
            }
            this.connection.connect();
            return this.connection;
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void setupConnectionManager() {
        this.client = Http.getInstance().createPooledClient();
    }

    protected void getNewConnectionInstanceQuiet(boolean changeState) {
        block4: {
            try {
                this.getNewConnectionInstance();
            }
            catch (IOException con) {
                LoggerFactory.getLogger(AbstractRestProcessService.class).warn(con.getMessage() + " " + this.getApiPath());
                if (!changeState) break block4;
                try {
                    this.setState(ServiceState.FAILED);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger(AbstractRestProcessService.class).error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void waitForConnection() {
        boolean portAvailable = false;
        while (!portAvailable) {
            try {
                this.getNewConnectionInstanceQuiet(false);
                if (this.getConnection().getResponseCode() == 400) {
                    portAvailable = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TimeUtils.sleep((int)100);
        }
    }

    @Override
    public void process(I data) throws IOException {
        this.process(data, "");
    }

    public void process(final I data, final String inTypeName) throws IOException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String bearer = AbstractRestProcessService.this.getBearerToken();
                    String input = AbstractRestProcessService.this.toSendString(data, inTypeName);
                    HttpPost post = (HttpPost)((HttpPost)((HttpPost)((HttpPost)Http.getInstance().createPost(AbstractRestProcessService.this.getApiPath()).setEntity(input)).setHeader("Accept", "application/json")).setHeader("Content-type", "application/json")).setHeader("Authorization", bearer);
                    if (AbstractRestProcessService.this.client != null) {
                        HttpResponse response = AbstractRestProcessService.this.client.execute((HttpRequest)post);
                        String output = response.getEntityAsString();
                        AbstractRestProcessService.this.handleReception(output);
                    } else {
                        LoggerFactory.getLogger(this.getClass()).info("Connection not yet open. Cannot process data.");
                    }
                }
                catch (IOException e1) {
                    LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e1.getMessage());
                }
            }
        });
    }

    protected String toSendString(I data, String inTypeName) throws IOException {
        return this.adjustRestQuery((String)this.getInputTranslator().to(data), inTypeName);
    }

    protected void handleReception(String data) {
        String result = this.adjustRestResponse(data);
        try {
            this.notifyCallbacks(this.getOutputTranslator().to((Object)result));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e.getMessage());
        }
    }

    protected abstract String adjustRestQuery(String var1, String var2);

    protected abstract String adjustRestResponse(String var1);

    @Override
    protected void handleInputStream(InputStream in) {
    }

    @Override
    protected ServiceState stop() {
        if (null != this.connection) {
            this.connection.disconnect();
            this.connection = null;
        }
        return super.stop();
    }
}

