/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import de.iip_ecosphere.platform.services.environment.MockingConnectorServiceWrapper;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.bytecode.Bytecode;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DataMapper {
    public static <T> Class<? extends T> createBaseDataUnitClass(final Class<T> cls) {
        final Class result = ((Bytecode.ClassBuilder.TypeAnnotationBuilder)Bytecode.getInstance().createClassBuilder("iip.mock." + cls.getSimpleName() + "Mock", cls, MockingConnectorServiceWrapper.class.getClassLoader()).implement(BaseDataUnitFunctions.class).annotate(JsonFilter.class).define("value", "iipFilter")).build().defineProperty("$period", Integer.TYPE).build().defineProperty("$repeats", Integer.TYPE).build().build();
        final Serializer ser = SerializerRegistry.getSerializer(cls);
        if (null != ser) {
            Serializer newSer = new Serializer<T>(){

                public T from(byte[] data) throws IOException {
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        JsonUtils.handleIipDataClasses((ObjectMapper)objectMapper);
                        return objectMapper.readValue(data, cls);
                    }
                    catch (JsonProcessingException e) {
                        throw new IOException(e);
                    }
                }

                public byte[] to(T source) throws IOException {
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        SimpleBeanPropertyFilter theFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"$period", "$repeats"});
                        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("iipFilter", theFilter);
                        return objectMapper.writer((FilterProvider)filters).writeValueAsBytes(source);
                    }
                    catch (JsonProcessingException e) {
                        throw new IOException(e);
                    }
                }

                public T clone(T origin) throws IOException {
                    return ser.clone(origin);
                }

                public Class<T> getType() {
                    return result;
                }
            };
            SerializerRegistry.registerSerializer((Serializer)newSer);
        }
        return result;
    }

    public static <T> void mapJsonData(InputStream stream, Class<T> cls, Consumer<T> cons) throws IOException {
        DataMapper.mapJsonData(stream, cls, cons, false);
    }

    public static <T> void mapJsonData(InputStream stream, Class<T> cls, Consumer<T> cons, boolean failOnUnknownProperties) throws IOException {
        DataMapper.mapJsonData(stream, cls, cons, failOnUnknownProperties, null);
    }

    public static <T> void mapJsonData(InputStream stream, Class<T> cls, Consumer<T> cons, boolean failOnUnknownProperties, Supplier<Boolean> continueFunction) throws IOException {
        try {
            IOIterator<T> iter = DataMapper.mapJsonDataToIterator(stream, cls, failOnUnknownProperties);
            while (iter.hasNext() && (null == continueFunction || continueFunction.get().booleanValue())) {
                cons.accept(iter.next());
            }
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        finally {
            if (null != stream) {
                stream.close();
            }
        }
    }

    public static <T> IOIterator<T> mapJsonDataToIterator(InputStream stream, Class<T> cls) throws IOException {
        return DataMapper.mapJsonDataToIterator(stream, cls, false);
    }

    public static <T> IOIterator<T> mapJsonDataToIterator(InputStream stream, Class<T> cls, boolean failOnUnknownProperties) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        JsonUtils.handleIipDataClasses((ObjectMapper)objectMapper);
        if (null == stream) {
            LoggerFactory.getLogger(DataMapper.class).error("No stream found, is file/resource name correct?");
        }
        return JsonUtils.createIterator((ObjectMapper)objectMapper, (InputStream)stream, cls);
    }

    public static interface BaseDataUnitFunctions {
        public int get$period();

        public int get$repeats();

        public void set$period(int var1);

        public void set$repeats(int var1);
    }

    public static class BaseMappingConsumer<B extends BaseDataUnit>
    extends MappingConsumer<B> {
        private int period;

        public BaseMappingConsumer(Class<B> cls, int period) {
            super(cls);
            this.period = period;
        }

        protected void infoGotData(B value) {
            LoggerFactory.getLogger(this.getClass()).info("Test data: {}", value);
        }

        @Override
        public void accept(B value) {
            boolean endless = ((BaseDataUnit)value).get$repeats() < 0;
            boolean once = ((BaseDataUnit)value).get$repeats() == 0;
            for (int count = 0; endless || once || count < ((BaseDataUnit)value).get$repeats(); ++count) {
                this.infoGotData(value);
                super.accept(value);
                this.period = ((BaseDataUnit)value).get$period();
                if (this.period <= 0) continue;
                TimeUtils.sleep((int)this.period);
                if (!once) continue;
                break;
            }
        }
    }

    public static class MappingConsumer<T>
    implements Consumer<T> {
        private Map<Class<?>, MapperEntry<T>> mapping = new HashMap();

        public MappingConsumer(Class<T> cls) {
            for (Method m : cls.getDeclaredMethods()) {
                if (m.isBridge() || !m.getName().startsWith("get") || m.getParameterCount() != 0 || m.getReturnType() == Void.TYPE) continue;
                this.mapping.put(m.getReturnType(), new MapperEntry(m));
            }
        }

        public <A> void addHandler(Class<A> cls, Consumer<A> cons) {
            if (null != cls && cons != null) {
                MapperEntry<T> entry = this.mapping.get(cls);
                if (entry != null) {
                    entry.setConsumer(cls, cons);
                } else {
                    LoggerFactory.getLogger(DataMapper.class).warn("No access mapping for class {}. Handler will be ignored", (Object)cls.getName());
                }
            }
        }

        @Override
        public void accept(T value) {
            if (null != value) {
                boolean accepted = false;
                for (MapperEntry<T> e : this.mapping.values()) {
                    accepted |= e.accept(value);
                }
                if (!accepted) {
                    LoggerFactory.getLogger(DataMapper.class).warn("Data {} was not processed further. {} mapper(s) available, but none reacted. If null, this could be a standard sink and normal but not expected.", value, (Object)this.mapping.size());
                }
            }
        }
    }

    private static class MapperEntry<T> {
        private Method getter;
        private Consumer<Object> translator;

        private MapperEntry(Method getter) {
            this.getter = getter;
        }

        private <A> void setConsumer(Class<A> cls, Consumer<A> consumer) {
            this.translator = o -> {
                try {
                    consumer.accept(cls.cast(o));
                }
                catch (ClassCastException e) {
                    LoggerFactory.getLogger(DataMapper.class).error("Cannot convert {} to {}", o, (Object)cls.getName());
                }
            };
        }

        private boolean accept(T instance) {
            boolean accepted = false;
            try {
                Object data = this.getter.invoke(instance, new Object[0]);
                if (null != data && null != this.translator) {
                    this.translator.accept(data);
                    accepted = true;
                } else {
                    LoggerFactory.getLogger(DataMapper.class).warn("No data ({}) obtained from {} or no translator found ({})", new Object[]{data, instance, this.translator});
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LoggerFactory.getLogger(DataMapper.class).error("Cannot process {}/{}: {}", new Object[]{instance, this.getter.getName(), e.getMessage()});
            }
            return accepted;
        }
    }

    public static abstract class BaseDataUnit
    implements BaseDataUnitFunctions {
        private int $period = 0;
        private int $repeats = 0;

        @Override
        public int get$period() {
            return this.$period;
        }

        @Override
        public int get$repeats() {
            return this.$repeats;
        }

        @Override
        public void set$period(int $period) {
            this.$period = $period;
        }

        @Override
        public void set$repeats(int $repeats) {
            this.$repeats = $repeats;
        }
    }
}

