/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider;

import com.sun.management.OperatingSystemMXBean;
import de.iip_ecosphere.platform.services.environment.UpdatingMonitoringService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.CapacityBaseUnit;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.AtomicDouble;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonValue;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Clock;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MeterRegistry;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.SystemMetrics;
import de.iip_ecosphere.platform.support.metrics.SystemMetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Tag;
import de.iip_ecosphere.platform.support.metrics.Timer;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class MetricsProvider {
    public static final MetricsAasConstructor.PushMeterPredicate TAG_PREDICATE = new MetricsAasConstructor.PushMeterPredicate(){

        @Override
        public boolean test(ElementsAccess parent, JsonValue meter) {
            Property prop;
            boolean allowPush = true;
            JsonObject m = meter.asJsonObject();
            JsonArray tags = m.getJsonArray("availableTags");
            if (null != tags && !tags.isEmpty() && null != (prop = parent.getProperty("id"))) {
                try {
                    String tag = "service:" + String.valueOf(prop.getValue());
                    allowPush = false;
                    for (int i = 0; !allowPush && i < tags.size(); ++i) {
                        allowPush = tags.getString(i).equals(tag);
                    }
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger(MetricsProvider.class).warn("Cannot read id property: {}", (Object)e.getMessage());
                }
            }
            return allowPush;
        }
    };
    public static final List<Tag> EMPTY_TAGS = Collections.unmodifiableList(new ArrayList());
    public static final MeterFilter[] DEFAULT_METER_FILTERS = new MeterFilter[]{MetricsFactory.denyNameStartsWith((String)"jvm."), MetricsFactory.denyNameStartsWith((String)"spring."), MetricsFactory.denyNameStartsWith((String)"logback."), MetricsFactory.denyNameStartsWith((String)"tomcat.")};
    public static final String TAG_SERVICE_SERVICE = "service";
    public static final String TAG_SERVICE_APPLICATION = "application";
    public static final String TAG_SERVICE_DEVICE = "device";
    public static final String TAG_SERVICE_SERVICEID = "serviceId";
    public static final String TAG_SERVICE_APPINSTID = "applicationInstance";
    public static final String SYS_MEM_TOTAL = "system.memory.total";
    public static final String SYS_MEM_FREE = "system.memory.free";
    public static final String SYS_MEM_USED = "system.memory.used";
    public static final String SYS_MEM_USAGE = "system.memory.usage";
    public static final String SYS_DISK_TOTAL = "system.disk.total";
    public static final String SYS_DISK_FREE = "system.disk.free";
    public static final String SYS_DISK_USABLE = "system.disk.usable";
    public static final String SYS_DISK_USED = "system.disk.used";
    public static final String DEVICE_CPU_TEMPERATURE = "device.cpu.temperature";
    public static final String DEVICE_CASE_TEMPERATURE = "device.case.temperature";
    public static final String DEVICE_TPU_CORES = "device.tpu.cores";
    public static final String DEVICE_GPU_CORES = "device.gpu.cores";
    public static final String DEVICE_CPU_CORES = "device.cpu.cores";
    public static final String SERVICE_TUPLES_SENT = "service.sent";
    public static final String SERVICE_TUPLES_RECEIVED = "service.received";
    public static final String SERVICE_TIME_PROCESSED = "service.processed";
    public static final CapacityBaseUnit DFLT_MEMORY = CapacityBaseUnit.BYTES;
    public static final CapacityBaseUnit DFLT_DISK = CapacityBaseUnit.BYTES;
    protected static final String ID_NOT_FOUND_ERRMSG = ": no item found with this identifier!";
    protected static final String NON_POSITIVE_ERRMSG = ": is not a positive number!";
    protected static final String NULL_ARG = " has a null value. This argument cannot be null!";
    private MeterRegistry registry;
    private final OperatingSystemMXBean osmxb;
    private boolean init;
    private Clock clock;
    private List<UpdatingMonitoringService> updaters;
    private CapacityBaseUnit memoryBaseUnit = DFLT_MEMORY;
    private CapacityBaseUnit diskBaseUnit = DFLT_DISK;
    private final Map<String, AtomicDouble> gauges;
    private final Map<String, Counter> counters;
    private final Map<String, Timer> timers;
    private boolean monitorNonNative;
    private double sysMemTotal;
    private double sysMemFree;
    private double sysMemUsed;
    private double sysMemUsage;
    private double sysDiskTotal;
    private double sysDiskFree;
    private double sysDiskUsable;
    private double sysDiskUsed;
    private float deviceCpuTemperature;
    private float deviceCaseTemperature;

    public MetricsProvider() {
        this(MetricsFactory.getInstance().createRegistry());
    }

    public MetricsProvider(MeterRegistry registry) {
        this(registry, true);
    }

    public MetricsProvider(MeterRegistry registry, boolean monitorNonNative) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry is null!");
        }
        this.registry = registry;
        this.clock = registry.config().clock();
        this.osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.gauges = new HashMap<String, AtomicDouble>();
        this.counters = new HashMap<String, Counter>();
        this.timers = new HashMap<String, Timer>();
        this.init = true;
        this.monitorNonNative = monitorNonNative;
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void registerNonNativeSystemMetrics() {
        this.registerMemoryMetrics();
        this.registerDiskMetrics();
        this.registerDeviceMetrics();
        if (this.monitorNonNative) {
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_MEM_USAGE, () -> this.sysMemUsage).description("Current percentage of physical memory in use")).baseUnit("percent").register(this.registry);
        }
    }

    public void registerMemoryMetrics() {
        if (this.monitorNonNative) {
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_MEM_TOTAL, () -> this.sysMemTotal).description("Total Physical memory of the system")).baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_MEM_FREE, () -> this.sysMemFree).description("Free Physical memory of the system")).baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_MEM_USED, () -> this.sysMemUsed).description("Physical memory currently in use")).baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
        }
    }

    public void registerDiskMetrics() {
        if (this.monitorNonNative) {
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_DISK_TOTAL, () -> this.sysDiskTotal).description("Total disk capacity of the system")).baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_DISK_FREE, () -> this.sysDiskFree).description("Total free disk capacity of the system")).baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_DISK_USABLE, () -> this.sysDiskUsable).description("Total usable disk capacity of the system")).baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)SYS_DISK_USED, () -> this.sysDiskUsed).description("Current total disk capacity currently in use or unavailable")).baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
        }
    }

    public void registerDeviceMetrics() {
        if (this.monitorNonNative) {
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)DEVICE_CPU_TEMPERATURE, () -> Float.valueOf(this.deviceCpuTemperature)).description("The CPU temperature of the device.")).baseUnit("degrees celsius").register(this.registry);
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)DEVICE_CASE_TEMPERATURE, () -> Float.valueOf(this.deviceCaseTemperature)).description("The case temperature (if available)")).baseUnit("degrees celsius").register(this.registry);
        }
    }

    public void removeDeviceMetrics() {
        if (this.monitorNonNative) {
            this.registry.remove(DEVICE_CPU_TEMPERATURE);
            this.registry.remove(DEVICE_CASE_TEMPERATURE);
            this.registry.remove(DEVICE_TPU_CORES);
            this.registry.remove(DEVICE_GPU_CORES);
            this.registry.remove(DEVICE_CPU_CORES);
        }
    }

    public void removeMemoryMetrics() {
        if (this.monitorNonNative) {
            this.registry.remove(SYS_MEM_TOTAL);
            this.registry.remove(SYS_MEM_FREE);
            this.registry.remove(SYS_MEM_USED);
        }
    }

    public void removeDiskMetrics() {
        if (this.monitorNonNative) {
            this.registry.remove(SYS_DISK_TOTAL);
            this.registry.remove(SYS_DISK_FREE);
            this.registry.remove(SYS_DISK_USABLE);
            this.registry.remove(SYS_DISK_USED);
        }
    }

    public int getNumberOfCustomGauges() {
        return this.gauges.size();
    }

    public int getNumberOfCustomCounters() {
        return this.counters.size();
    }

    public int getNumberOfCustomTimers() {
        return this.timers.size();
    }

    public void addGaugeValue(String gaugeId, double value) {
        if (gaugeId == null) {
            throw new IllegalArgumentException("gaugeId has a null value. This argument cannot be null!");
        }
        if (this.gauges.containsKey(gaugeId)) {
            this.gauges.get(gaugeId).set(value);
        } else {
            AtomicDouble gauge = (AtomicDouble)this.registry.gauge(gaugeId, (Number)new AtomicDouble(value));
            this.gauges.put(gaugeId, gauge);
        }
    }

    public void removeGauge(String gaugeId) {
        if (!this.gauges.containsKey(gaugeId)) {
            throw new IllegalArgumentException(gaugeId + ID_NOT_FOUND_ERRMSG);
        }
        this.gauges.remove(gaugeId);
        this.registry.remove(gaugeId);
    }

    public double getGaugeValue(String gaugeId) {
        if (this.gauges.containsKey(gaugeId)) {
            return this.gauges.get(gaugeId).doubleValue();
        }
        return 0.0;
    }

    public double getRegisteredGaugeValue(String gaugeId) {
        Gauge g = this.registry.getGauge(gaugeId);
        if (null != g) {
            return g.value();
        }
        return this.getGaugeValue(gaugeId);
    }

    private void addCounter(String counterId) {
        Counter counter = this.registry.counter(counterId, new String[0]);
        this.counters.put(counterId, counter);
    }

    public void increaseCounterBy(String counterId, double value) {
        if (counterId == null) {
            throw new IllegalArgumentException("counterId has a null value. This argument cannot be null!");
        }
        if (value < 0.0) {
            throw new IllegalArgumentException(value + NON_POSITIVE_ERRMSG);
        }
        if (!this.counters.containsKey(counterId)) {
            this.addCounter(counterId);
        }
        MetricsProvider.increaseCounterBy(this.counters.get(counterId), value);
    }

    public static void increaseCounterBy(Counter counter, double value) {
        if (null != counter) {
            counter.increment(value);
        }
    }

    public static void recordMsTime(Timer timer, TimeSupplier timeSupplier, Runnable function) {
        function.run();
        timer.record(timeSupplier.get(), TimeUnit.MILLISECONDS);
    }

    public static void recordNsTime(Timer timer, TimeSupplier timeSupplier, Runnable function) {
        function.run();
        timer.record(timeSupplier.get(), TimeUnit.NANOSECONDS);
    }

    public void increaseCounter(String counterId) {
        this.increaseCounterBy(counterId, 1.0);
    }

    public void removeCounter(String counterId) {
        if (!this.counters.containsKey(counterId)) {
            throw new IllegalArgumentException(counterId + ID_NOT_FOUND_ERRMSG);
        }
        this.counters.remove(counterId);
        this.registry.remove(counterId);
    }

    public double getCounterValue(String counterId) {
        if (this.counters.containsKey(counterId)) {
            return this.counters.get(counterId).count();
        }
        return 0.0;
    }

    public double getRegisteredCounterValue(String counterId) {
        Counter c = this.registry.getCounter(counterId);
        if (null != c) {
            return c.count();
        }
        return this.getCounterValue(counterId);
    }

    protected void addTimer(String timerId) {
        if (timerId == null) {
            throw new IllegalArgumentException("timerId has a null value. This argument cannot be null!");
        }
        Timer timer = this.registry.timer(timerId, new String[0]);
        this.timers.put(timerId, timer);
    }

    public void removeTimer(String timerId) {
        if (!this.timers.containsKey(timerId)) {
            throw new IllegalArgumentException(timerId + ID_NOT_FOUND_ERRMSG);
        }
        this.timers.remove(timerId);
        this.registry.remove(timerId);
    }

    public void recordWithTimer(String timerId, Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        this.timers.get(timerId).record(runnable);
    }

    public <T> T recordWithTimer(String timerId, Supplier<T> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        return (T)this.timers.get(timerId).record(supplier);
    }

    public void recordWithTimer(String timerId, long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException("cannot record negative time!");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        this.timers.get(timerId).record(time, unit);
    }

    public double getTotalTimeFromTimer(String timerId) {
        if (this.timers.containsKey(timerId)) {
            Timer t = this.timers.get(timerId);
            return t.totalTime(t.baseTimeUnit());
        }
        return 0.0;
    }

    public double getMaxTimeFromTimer(String timerId) {
        if (this.timers.containsKey(timerId)) {
            Timer t = this.timers.get(timerId);
            return t.max(t.baseTimeUnit());
        }
        return 0.0;
    }

    public long getTimerCount(String timerId) {
        if (this.timers.containsKey(timerId)) {
            return this.timers.get(timerId).count();
        }
        return 0L;
    }

    public long getRegisteredTimerCount(String timerId) {
        Timer t = this.registry.getTimer(timerId);
        if (null != t) {
            return t.count();
        }
        return this.getTimerCount(timerId);
    }

    public void addService(UpdatingMonitoringService service) {
        if (null != service) {
            if (null == this.updaters) {
                this.updaters = new ArrayList<UpdatingMonitoringService>();
            }
            if (!this.updaters.contains(service)) {
                this.updaters.add(service);
            }
        }
    }

    public void calculateMetrics() {
        this.calculateNonNativeSystemMetrics();
        if (null != this.updaters) {
            for (int i = this.updaters.size() - 1; i >= 0; --i) {
                this.updaters.get(i).calculateMetrics();
            }
        }
    }

    public void calculateNonNativeSystemMetrics() {
        if (this.init) {
            this.registerNonNativeSystemMetrics();
            this.init = false;
        }
        this.sysMemTotal = (double)this.osmxb.getTotalMemorySize() / this.memoryBaseUnit.byteValue();
        this.sysMemFree = (double)this.osmxb.getFreeMemorySize() / this.memoryBaseUnit.byteValue();
        this.sysMemUsed = this.sysMemTotal - this.sysMemFree;
        this.sysMemUsage = this.sysMemUsed / this.sysMemTotal;
        File[] dirs = File.listRoots();
        this.sysDiskTotal = 0.0;
        this.sysDiskFree = 0.0;
        this.sysDiskUsable = 0.0;
        for (File dir : dirs) {
            this.sysDiskTotal += (double)dir.getTotalSpace();
            this.sysDiskFree += (double)dir.getFreeSpace();
            this.sysDiskUsable += (double)dir.getUsableSpace();
        }
        this.sysDiskTotal /= this.diskBaseUnit.byteValue();
        this.sysDiskFree /= this.diskBaseUnit.byteValue();
        this.sysDiskUsable /= this.diskBaseUnit.byteValue();
        this.sysDiskUsed = this.sysDiskTotal - this.sysDiskFree;
        SystemMetrics sysM = SystemMetricsFactory.getSystemMetrics();
        this.deviceCaseTemperature = sysM.getCaseTemperature();
        this.deviceCpuTemperature = sysM.getCpuTemperature();
    }

    public void setMemoryBaseUnit(CapacityBaseUnit memoryBaseUnit) {
        if (memoryBaseUnit == null) {
            throw new IllegalArgumentException("memoryBaseUnit has a null value. This argument cannot be null!");
        }
        this.memoryBaseUnit = memoryBaseUnit;
    }

    public CapacityBaseUnit getMemoryBaseUnit() {
        return this.memoryBaseUnit;
    }

    public void setDiskBaseUnit(CapacityBaseUnit diskBaseUnit) {
        if (diskBaseUnit == null) {
            throw new IllegalArgumentException(String.valueOf((Object)diskBaseUnit) + NULL_ARG);
        }
        this.diskBaseUnit = diskBaseUnit;
    }

    public CapacityBaseUnit getDiskBaseUnit() {
        return this.diskBaseUnit;
    }

    public String getMeter(String name, Iterable<Tag> tags) {
        Meter meter = this.registry.getMeter(name, tags);
        if (null != meter) {
            return this.jsonParser(meter);
        }
        throw new IllegalArgumentException("Meter " + String.valueOf(meter) + " not found.");
    }

    public String toJson(String identifier, boolean update, MeterFilter ... filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (null != identifier) {
            sb.append("\"id\":\"" + identifier + "\",");
        }
        sb.append("\"meters\":{");
        boolean first = true;
        for (Meter meter : MetricsProvider.filter(this.registry.getMeters(), true, filter)) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"" + meter.getName() + "\":");
            sb.append(this.jsonParser(meter));
            first = false;
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    public static List<Meter> filter(List<Meter> meters, boolean copy, MeterFilter ... filters) {
        List<Meter> result = meters;
        if (filters.length > 0 && meters.size() > 0) {
            if (copy) {
                result = new ArrayList<Meter>(meters);
            }
            for (int m = meters.size() - 1; m >= 0; --m) {
                Meter meter = meters.get(m);
                boolean include = MetricsProvider.include(meter.getId(), filters);
                if (include) continue;
                result.remove(m);
            }
        }
        return result;
    }

    public static boolean include(Meter.Id id, MeterFilter ... filters) {
        boolean include = true;
        for (int f = 0; include && f < filters.length; ++f) {
            MeterFilter.MeterFilterReply reply = filters[f].accept(id);
            if (MeterFilter.MeterFilterReply.DENY == reply) {
                include = false;
                continue;
            }
            if (MeterFilter.MeterFilterReply.ACCEPT == reply) {
                include = true;
                break;
            }
            include = true;
        }
        return include;
    }

    public static boolean include(String id, MeterFilter ... filters) {
        return MetricsProvider.include(MetricsFactory.buildId((String)id, null, null, null, null), filters);
    }

    public static MeterFilter[] append(MeterFilter[] base, MeterFilter ... addition) {
        int i;
        MeterFilter[] result = new MeterFilter[base.length + addition.length];
        int pos = 0;
        for (i = 0; i < base.length; ++i) {
            result[pos++] = base[i];
        }
        for (i = 0; i < addition.length; ++i) {
            result[pos++] = addition[i];
        }
        return result;
    }

    public static void apply(MeterRegistry registry, MeterFilter ... filters) {
        for (MeterFilter f : filters) {
            registry.config().meterFilter(f);
        }
    }

    public String getGauge(String name) {
        if (!this.gauges.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.getGauge(name));
    }

    public String getCounter(String name) {
        if (!this.counters.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.getCounter(name));
    }

    public String getTimer(String name) {
        if (!this.timers.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.getTimer(name));
    }

    private String jsonParser(Meter meter) {
        String description = "";
        if (description != null) {
            description = description.replaceAll("\"", "''");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"name\":\"").append(meter.getId().getName()).append("\",");
        sb.append("\"description\":\"").append(description).append("\",");
        sb.append("\"baseUnit\":\"").append(meter.getId().getBaseUnit()).append("\",");
        sb.append("\"measurements\":[");
        for (Measurement m : meter.measure()) {
            sb.append("{");
            sb.append("\"statistic\":\"").append(m.getStatisticAsString()).append("\",");
            sb.append("\"value\":").append(String.format(Locale.ROOT, "%f", m.getValue()));
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("],\"availableTags\":[");
        boolean first = true;
        for (Tag t : meter.getId().getTagsAsIterable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("\"" + t.getKey() + ":" + t.getValue() + "\"");
            first = false;
        }
        sb.append("]}");
        return sb.toString();
    }

    public String getCustomGaugeList() {
        return this.mapJsonParser(this.gauges);
    }

    public String getCustomCounterList() {
        return this.mapJsonParser(this.counters);
    }

    public String getCustomTimerList() {
        return this.mapJsonParser(this.timers);
    }

    public String getTaggedMeterList() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("\"jvm.buffer.count\",");
        sb.append("\"jvm.buffer.memory.used\",");
        sb.append("\"jvm.buffer.total.capacity\",");
        sb.append("\"jvm.gc.pause\",");
        sb.append("\"jvm.memory.committed\",");
        sb.append("\"jvm.memory.max\",");
        sb.append("\"jvm.memory.used\",");
        sb.append("\"jvm.threads.states\",");
        sb.append(" \"logback.events\"");
        sb.append("]");
        return sb.toString();
    }

    public String getSimpleMeterList() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("\"jvm.classes.loaded\",");
        sb.append("\"jvm.classes.unloaded\",");
        sb.append("\"jvm.gc.live.data.size\",");
        sb.append("\"jvm.gc.max.data.size\",");
        sb.append("\"jvm.gc.memory.allocated\",");
        sb.append("\"jvm.gc.memory.promoted\",");
        sb.append("\"jvm.threads.daemon\",");
        sb.append("\"jvm.threads.live\",");
        sb.append("\"jvm.threads.peak\",");
        sb.append("\"process.cpu.usage\",");
        sb.append("\"process.start.time\",");
        sb.append("\"process.uptime\",");
        sb.append("\"system.cpu.count\",");
        sb.append("\"system.cpu.usage\",");
        sb.append("\"system.disk.free\",");
        sb.append("\"system.disk.total\",");
        sb.append("\"system.disk.usable\",");
        sb.append("\"system.disk.used\",");
        sb.append("\"system.memory.free\",");
        sb.append("\"system.memory.total\",");
        sb.append("\"system.memory.usage\",");
        sb.append("\"system.memory.used\"");
        sb.append("]");
        return sb.toString();
    }

    private String mapJsonParser(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public Counter createServiceReceivedCounter(String serviceName, String serviceId, String appId, String appInstanceId) {
        return this.createServiceSentReceivedCounter(true, serviceName, serviceId, appId, appInstanceId);
    }

    public Counter createServiceSentCounter(String serviceName, String serviceId, String appId, String appInstanceId) {
        return this.createServiceSentReceivedCounter(false, serviceName, serviceId, appId, appInstanceId);
    }

    public Counter createServiceSentReceivedCounter(boolean receive, String serviceName, String serviceId, String appId, String appInstanceId) {
        String name;
        String description;
        if (receive) {
            description = "Tuples received by a service";
            name = SERVICE_TUPLES_RECEIVED;
        } else {
            description = "Tuples sent out by a service";
            name = SERVICE_TUPLES_SENT;
        }
        return (Counter)((Counter.CounterBuilder)((Counter.CounterBuilder)MetricsFactory.buildCounter((String)name).baseUnit("tuple/s").description(description)).tags(new String[]{TAG_SERVICE_SERVICE, serviceName, TAG_SERVICE_APPLICATION, appId, TAG_SERVICE_DEVICE, Id.getDeviceId(), TAG_SERVICE_SERVICEID, serviceId, TAG_SERVICE_APPINSTID, ServiceBase.validateApplicationInstanceId(appInstanceId)})).register(this.getRegistry());
    }

    public Timer createServiceProcessingTimer(String serviceName, String serviceId, String appId, String appInstanceId) {
        return (Timer)((Timer.TimerBuilder)((Timer.TimerBuilder)MetricsFactory.buildTimer((String)SERVICE_TIME_PROCESSED).description("Main processing time of a service")).tags(new String[]{TAG_SERVICE_SERVICE, serviceName, TAG_SERVICE_APPLICATION, appId, TAG_SERVICE_DEVICE, Id.getDeviceId(), TAG_SERVICE_SERVICEID, serviceId, TAG_SERVICE_APPINSTID, ServiceBase.validateApplicationInstanceId(appInstanceId)})).register(this.getRegistry());
    }

    public static interface TimeSupplier {
        public long get();
    }
}

