/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonArrayBuilder;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import de.iip_ecosphere.platform.support.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class TimerRepresentation
extends MeterRepresentation
implements Timer {
    private long count;
    private TimeUnit baseTimeUnit;
    private List<Measurement> measurements;
    private long totalTime;
    private long maxTime;
    private List<Long> updates;

    private TimerRepresentation(JsonObject object, String ... tags) {
        super(object, Meter.Type.TIMER, tags);
        try {
            this.baseTimeUnit = TimeUnit.valueOf(object.getString("baseUnit").toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("This object does not map a valid Timer!", iae);
        }
        long conv = this.baseTimeUnit.toNanos(1L);
        JsonArray ja = object.getJsonArray("measurements");
        if (ja.size() != 3) {
            throw new IllegalArgumentException("This object does not map a valid Timer!");
        }
        this.measurements = new ArrayList<Measurement>();
        boolean cFlag = false;
        boolean ttFlag = false;
        boolean mtFlag = false;
        block7: for (int i = 0; i < 3; ++i) {
            JsonObject jo = ja.getJsonObject(i);
            switch (Statistic.valueOf((String)jo.getString("statistic"))) {
                case COUNT: {
                    if (cFlag) {
                        throw new IllegalArgumentException("This object does not map a valid Timer!");
                    }
                    this.count = jo.getJsonNumber("value").longValue();
                    this.measurements.add(MetricsFactory.buildMeasurement(() -> this.count, (Statistic)Statistic.COUNT));
                    cFlag = true;
                    continue block7;
                }
                case TOTAL_TIME: {
                    if (ttFlag) {
                        throw new IllegalArgumentException("This object does not map a valid Timer!");
                    }
                    double aux = jo.getJsonNumber("value").doubleValue();
                    this.totalTime = (long)(aux * (double)conv);
                    this.measurements.add(MetricsFactory.buildMeasurement(() -> this.totalTime(this.baseTimeUnit), (Statistic)Statistic.TOTAL_TIME));
                    ttFlag = true;
                    continue block7;
                }
                case MAX: {
                    if (mtFlag) {
                        throw new IllegalArgumentException("This object does not map a valid Timer!");
                    }
                    double aux = jo.getJsonNumber("value").doubleValue();
                    this.maxTime = (long)(aux * (double)conv);
                    this.measurements.add(MetricsFactory.buildMeasurement(() -> this.max(this.baseTimeUnit), (Statistic)Statistic.MAX));
                    mtFlag = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("This object does not map a valid Timer!");
                }
            }
        }
        this.updates = new ArrayList<Long>();
    }

    private TimerRepresentation(String name) {
        super(name, Meter.Type.TIMER);
        this.count = 0L;
        this.baseTimeUnit = TimeUnit.SECONDS;
        this.totalTime = 0L;
        this.maxTime = 0L;
        this.updates = new ArrayList<Long>();
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.count, (Statistic)Statistic.COUNT));
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.totalTime, (Statistic)Statistic.TOTAL_TIME));
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.maxTime, (Statistic)Statistic.MAX));
    }

    public static Timer parseTimer(JsonObject object, String ... tags) {
        return new TimerRepresentation(object, tags);
    }

    public static Timer createNewTimer(String name) {
        return new TimerRepresentation(name);
    }

    public void record(long amount, TimeUnit unit) {
        long aux = amount * unit.toNanos(1L);
        if (this.maxTime < aux) {
            this.maxTime = aux;
        }
        ++this.count;
        this.totalTime += aux;
        this.updates.add(aux);
    }

    public <T> T record(Supplier<T> supplier) {
        Timer.Sample timer = MetricsFactory.getInstance().createTimerStart();
        T supply = supplier.get();
        timer.stop((Timer)this);
        return supply;
    }

    public <T> T recordCallable(Callable<T> callable) throws Exception {
        Timer.Sample timer = MetricsFactory.getInstance().createTimerStart();
        T supply = callable.call();
        timer.stop((Timer)this);
        return supply;
    }

    public void record(Runnable runnable) {
        Timer.Sample timer = MetricsFactory.getInstance().createTimerStart();
        runnable.run();
        timer.stop((Timer)this);
    }

    public long count() {
        return this.count;
    }

    public double totalTime(TimeUnit unit) {
        return (double)this.totalTime / (double)unit.toNanos(1L);
    }

    public double max(TimeUnit unit) {
        return (double)this.maxTime / (double)unit.toNanos(1L);
    }

    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.measurements;
    }

    @Override
    public JsonObject getUpdater() {
        JsonObjectBuilder job = Json.createObjectBuilder();
        JsonArrayBuilder jab = Json.createArrayBuilder();
        job.add("name", this.getId().getName());
        for (long update : this.updates) {
            jab.add((double)update);
        }
        job.add("recordings", (JsonArray)jab.build());
        return (JsonObject)job.build();
    }

    public double mean(TimeUnit unit) {
        return this.count > 0L ? this.totalTime(unit) / (double)this.count : 0.0;
    }
}

