/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.services.environment.metricsProvider.CapacityBaseUnit;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class CapacityBaseUnitTest {
    private static final double ONE_BYTE = 1.0;
    private static final double ONE_KILO = 1024.0;
    private static final double ONE_MEGA = 1048576.0;
    private static final double ONE_GIGA = 1.073741824E9;
    private static final double ONE_TERA = 1.099511627776E12;
    private static final String SUFFIX_BYTES = "bytes";
    private static final String SUFFIX_KILOS = "kilobytes";
    private static final String SUFFIX_MEGAS = "megabytes";
    private static final String SUFFIX_GIGAS = "gigabytes";
    private static final String SUFFIX_TERAS = "terabytes";
    private static final String RANDOM = "random";

    @Test
    public void testByteValueOfBytes() {
        Assert.assertEquals((double)1.0, (double)CapacityBaseUnit.BYTES.byteValue(), (double)0.0);
    }

    @Test
    public void testByteValueOfKilobytes() {
        Assert.assertEquals((double)1024.0, (double)CapacityBaseUnit.KILOBYTES.byteValue(), (double)0.0);
    }

    @Test
    public void testByteValueOfMegabytes() {
        Assert.assertEquals((double)1048576.0, (double)CapacityBaseUnit.MEGABYTES.byteValue(), (double)0.0);
    }

    @Test
    public void testByteValueOfGigabytes() {
        Assert.assertEquals((double)1.073741824E9, (double)CapacityBaseUnit.GIGABYTES.byteValue(), (double)0.0);
    }

    @Test
    public void testByteValueOfTerabytes() {
        Assert.assertEquals((double)1.099511627776E12, (double)CapacityBaseUnit.TERABYTES.byteValue(), (double)0.0);
    }

    @Test
    public void testStringValueOfBytes() {
        Assert.assertEquals((Object)SUFFIX_BYTES, (Object)CapacityBaseUnit.BYTES.stringValue());
    }

    @Test
    public void testStringValueOfKilobytes() {
        Assert.assertEquals((Object)SUFFIX_KILOS, (Object)CapacityBaseUnit.KILOBYTES.stringValue());
    }

    @Test
    public void testStringValueOfMegabytes() {
        Assert.assertEquals((Object)SUFFIX_MEGAS, (Object)CapacityBaseUnit.MEGABYTES.stringValue());
    }

    @Test
    public void testStringValueOfGigabytes() {
        Assert.assertEquals((Object)SUFFIX_GIGAS, (Object)CapacityBaseUnit.GIGABYTES.stringValue());
    }

    @Test
    public void testStringValueOfTerabytes() {
        Assert.assertEquals((Object)SUFFIX_TERAS, (Object)CapacityBaseUnit.TERABYTES.stringValue());
    }

    @Test
    public void testValueOfBytes() {
        Assert.assertEquals((Object)CapacityBaseUnit.BYTES, (Object)CapacityBaseUnit.valueOf((String)SUFFIX_BYTES.toUpperCase()));
    }

    @Test
    public void testValueOfKilobytes() {
        Assert.assertEquals((Object)CapacityBaseUnit.KILOBYTES, (Object)CapacityBaseUnit.valueOf((String)SUFFIX_KILOS.toUpperCase()));
    }

    @Test
    public void testValueOfMegabytes() {
        Assert.assertEquals((Object)CapacityBaseUnit.MEGABYTES, (Object)CapacityBaseUnit.valueOf((String)SUFFIX_MEGAS.toUpperCase()));
    }

    @Test
    public void testValueOfGigabytes() {
        Assert.assertEquals((Object)CapacityBaseUnit.GIGABYTES, (Object)CapacityBaseUnit.valueOf((String)SUFFIX_GIGAS.toUpperCase()));
    }

    @Test
    public void testValueOfterabytes() {
        Assert.assertEquals((Object)CapacityBaseUnit.TERABYTES, (Object)CapacityBaseUnit.valueOf((String)SUFFIX_TERAS.toUpperCase()));
    }

    @Test
    public void testValueOfNull() {
        TestUtils.assertThrows(NullPointerException.class, () -> CapacityBaseUnit.valueOf(null));
    }

    @Test
    public void testValueOfRandomString() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> CapacityBaseUnit.valueOf((String)RANDOM.toUpperCase()));
    }
}

