/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.events.EventHandlingConnector;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class MultiConnectorServiceWrapper
extends AbstractService {
    private static final Comparator<Class<?>> CLASS_COMPARATOR = (c1, c2) -> c1.getName().compareTo(c2.getName());
    private Map<Class<?>, Connector<?, ?, ?, ?>> inConnectors = new TreeMap(CLASS_COMPARATOR);
    private Map<Class<?>, Connector<?, ?, ?, ?>> outConnectors = new TreeMap(CLASS_COMPARATOR);
    private Supplier<ConnectorParameter> connParamSupplier;
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();
    private String outPath;
    private String inPath;

    public MultiConnectorServiceWrapper(YamlService yaml, Supplier<ConnectorParameter> connParamSupplier) {
        super(yaml);
        this.connParamSupplier = connParamSupplier;
        AbstractService.addConfigurer(this.paramConfigurers, "outPath", String.class, TypeTranslators.STRING, v -> this.setOutPath((String)v), () -> this.outPath, "iip.app." + this.getId() + ".outPath");
        AbstractService.addConfigurer(this.paramConfigurers, "inPath", String.class, TypeTranslators.STRING, v -> this.setInPath((String)v), () -> this.inPath, "iip.app." + this.getId() + ".inPath");
    }

    public void addConnector(Connector<?, ?, ?, ?> connector) {
        if (null != connector) {
            this.inConnectors.put(connector.getConnectorInputType(), connector);
            this.outConnectors.put(connector.getConnectorOutputType(), connector);
        }
    }

    public boolean isEmpty() {
        return this.inConnectors.isEmpty();
    }

    public <CI> EventHandlingConnector getEventHandlingConnector(Class<CI> ciCls) {
        return (EventHandlingConnector)this.inConnectors.get(ciCls);
    }

    protected Collection<Connector<?, ?, ?, ?>> getConnectors() {
        return this.inConnectors.values();
    }

    protected static Class<?> resolve(Class<?> cls) {
        String name = cls.getName();
        Object modName = name;
        String mockPrefix = "iip.mock";
        String mockSuffix = "Mock";
        if (((String)modName).startsWith("iip.mock") && ((String)modName).endsWith("Mock")) {
            modName = ((String)modName).substring("iip.mock".length());
            modName = ((String)modName).substring(0, ((String)modName).length() - "Mock".length());
            modName = "iip.datatypes" + (String)modName;
        }
        String implSuffix = "Impl";
        if (((String)modName).endsWith("Impl")) {
            modName = ((String)modName).substring(0, ((String)modName).length() - "Impl".length());
        }
        if (!name.equals(modName)) {
            try {
                cls = Class.forName((String)modName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return cls;
    }

    protected static <CO> Class<? extends CO> getActualConnectorOutputType(Class<CO> connectorOutType) {
        Class<Object> result = connectorOutType;
        if (result.isInterface()) {
            try {
                result = Class.forName(connectorOutType.getName() + "Impl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public <CI> void send(Class<CI> cls, CI data) {
        try {
            Connector<?, ?, ?, ?> conn = this.inConnectors.get(cls);
            if (conn != null) {
                conn.write(data);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger((Object)this).error("Data loss, cannot send data: " + e.getMessage());
        }
    }

    public <CO> void setReceptionCallback(ReceptionCallback<CO> callback) {
        try {
            Connector<?, ?, ?, ?> conn = this.outConnectors.get(callback.getType());
            conn.setReceptionCallback(callback);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Data loss, cannot set reception callback: " + e.getMessage());
        }
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        this.doSetState(state);
        ConnectorParameter param = null;
        for (Connector<?, ?, ?, ?> connector : this.getConnectors()) {
            try {
                if (ServiceState.STARTING == state) {
                    if (null == param) {
                        param = this.connParamSupplier.get();
                    }
                    connector.connect(param);
                    connector.enableNotifications(param.getNotificationInterval() == 0);
                    this.doSetState(ServiceState.RUNNING);
                    continue;
                }
                if (ServiceState.STOPPING == state) {
                    connector.disconnect();
                    this.doSetState(ServiceState.STOPPED);
                    continue;
                }
                if (ServiceState.UNDEPLOYING != state) continue;
                connector.dispose();
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }
    }

    protected void doSetState(ServiceState state) throws ExecutionException {
        super.setState(state);
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    public void enablePolling(boolean enablePolling) {
        this.getConnectors().forEach(connector -> connector.enablePolling(enablePolling));
    }

    public void enableNotifications(boolean enableNotifications) {
        this.getConnectors().forEach(connector -> connector.enableNotifications(enableNotifications));
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    private void setInPath(String inPath) {
        if (inPath != null && inPath.length() > 0) {
            this.inPath = inPath;
        }
    }

    private void setOutPath(String outPath) {
        if (outPath != null && outPath.length() > 0) {
            this.outPath = outPath;
        }
    }

    public String getOutPath(String cfgPath) {
        String result = cfgPath;
        if (this.outPath != null) {
            result = this.outPath;
        }
        return result;
    }

    public String getInPath(String cfgPath) {
        String result = cfgPath;
        if (this.inPath != null) {
            result = this.inPath;
        }
        return result;
    }
}

