/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;

public class AasCreator {
    public static final String URN_AAS = "urn:::AAS:::AiTestAas#";
    public static final String AAS_NAME = "AiTestAas";
    public static final String AAS_SUBMODEL_NAME = "AiService";
    public static final String AAS_SUBMODEL_PROPERTY_ID = "id";
    public static final String AAS_SUBMODEL_PROPERTY_NAME = "name";
    public static final String AAS_SUBMODEL_PROPERTY_VERSION = "version";
    public static final String AAS_SUBMODEL_PROPERTY_DESCRIPTION = "description";
    public static final String AAS_SUBMODEL_PROPERTY_STATE = "state";
    public static final String AAS_SUBMODEL_PROPERTY_KIND = "kind";
    public static final String AAS_SUBMODEL_PROPERTY_DEPLOYABLE = "deployable";
    public static final String AAS_SUBMODEL_OPERATION_PASSIVATE = "passivate";
    public static final String AAS_SUBMODEL_OPERATION_ACTIVATE = "activate";
    public static final String AAS_SUBMODEL_OPERATION_SETSTATE = "setState";
    public static final String AAS_SUBMODEL_OPERATION_GETSTATE = "getState";
    public static final String AAS_SUBMODEL_OPERATION_MIGRATE = "migrate";
    public static final String AAS_SUBMODEL_OPERATION_UPDATE = "update";
    public static final String AAS_SUBMODEL_OPERATION_SWITCH = "switchTo";
    public static final String AAS_SUBMODEL_OPERATION_RECONF = "reconfigure";

    public static Aas createAas(SetupSpec spec, Service service) {
        return AasCreator.createAas(spec, service, null);
    }

    public static Aas createAas(SetupSpec spec, Service service, AasResult result) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator iCreator = factory.createInvocablesCreator(spec);
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(AAS_NAME, URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder(AAS_SUBMODEL_NAME, null);
        ServiceStub stub = new ServiceStub(iCreator, service.getId(), () -> AasFactory.getInstance().obtainRegistry(spec).retrieveAas(URN_AAS), new String[]{AAS_SUBMODEL_NAME});
        AuthenticationDescriptor auth = AasPartRegistry.getSubmodelAuthentication();
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_ID).setType(Type.STRING), (Object)service.getId(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_ID), (Invokable)stub.getSetter(AAS_SUBMODEL_PROPERTY_ID)).build(auth);
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_NAME).setType(Type.STRING), (Object)service.getName(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_NAME), (Invokable)InvocablesCreator.READ_ONLY).build(auth);
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_VERSION).setType(Type.STRING), (Object)service.getVersion().toString(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_VERSION), (Invokable)InvocablesCreator.READ_ONLY).build(auth);
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_DESCRIPTION).setType(Type.STRING), (Object)service.getDescription(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_DESCRIPTION), (Invokable)InvocablesCreator.READ_ONLY).build(auth);
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_STATE).setValue(Type.STRING, (Object)service.getState()).build(auth);
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_KIND).setType(Type.STRING), (Object)service.getKind().toString(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_KIND), (Invokable)InvocablesCreator.READ_ONLY).build(auth);
        AasUtils.setValue((Property.PropertyBuilder)smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_DEPLOYABLE).setType(Type.BOOLEAN), (Object)service.isDeployable(), (Invokable)stub.getGetter(AAS_SUBMODEL_PROPERTY_DEPLOYABLE), (Invokable)InvocablesCreator.READ_ONLY).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_ACTIVATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_ACTIVATE)).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_PASSIVATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_PASSIVATE)).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_SETSTATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_SETSTATE)).addInputVariable(AAS_SUBMODEL_PROPERTY_STATE, Type.STRING).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_GETSTATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_GETSTATE)).build(Type.STRING, auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_MIGRATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_MIGRATE)).addInputVariable("resourceId", Type.STRING).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_UPDATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_UPDATE)).addInputVariable("location", Type.STRING).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_SWITCH).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_SWITCH)).addInputVariable("targetId", Type.STRING).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_RECONF).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_RECONF)).addInputVariable("values", Type.STRING).addOutputVariable("result", Type.STRING).build(auth);
        smBuilder.build();
        if (result != null) {
            result.stub = stub;
        }
        return (Aas)aasBuilder.build();
    }

    public static class AasResult {
        private ServiceStub stub;

        public ServiceStub getStub() {
            return this.stub;
        }
    }
}

