/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.services.environment.metricsProvider.CapacityBaseUnit;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MeterRegistry;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import de.iip_ecosphere.platform.support.metrics.Timer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class MetricsProviderTest {
    private static final String ID_OK = "id.ok";
    private static final String ID_GOOD = "id.good";
    private static final String ID_PASSABLE = "id.passable";
    private static final String ID_BAD = "id.bad";
    private static MetricsProvider provider;

    protected MetricsProvider createProvider(MeterRegistry registry) {
        return new MetricsProvider(registry);
    }

    @Before
    public void setUpMetricsProvider() {
        provider = this.createProvider(MetricsFactory.getInstance().createRegistry());
    }

    @Test
    public void testInitOk() {
        MetricsProvider mProvider = this.createProvider(MetricsFactory.getInstance().createRegistry());
        Assert.assertNotNull((Object)mProvider);
    }

    @Test
    public void testInitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> this.createProvider(null));
    }

    @Test
    public void testGaugeCrudOperations() {
        double value = 1.0;
        double value2 = 1.2;
        double negVal = -1.3;
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.addGaugeValue(null, 1.0));
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        provider.addGaugeValue(ID_GOOD, value);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)value, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        provider.addGaugeValue(ID_GOOD, value2);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)value2, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        provider.calculateMetrics();
        Assert.assertTrue((provider.getRegisteredGaugeValue("system.memory.total") > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)value2, (double)provider.getRegisteredGaugeValue(ID_GOOD), (double)0.0);
        provider.addGaugeValue(ID_GOOD, negVal);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)negVal, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(null), (double)0.0);
        provider.removeGauge(ID_GOOD);
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(ID_GOOD));
    }

    @Test
    public void testCounterCrudOperations() {
        double value = 1.1;
        double valueX2 = value + value;
        double negValue = -value;
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomCounters());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounter(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounterBy((String)null, value));
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomCounters());
        provider.increaseCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)1.0, (double)provider.getCounterValue(ID_GOOD), (double)0.0);
        provider.increaseCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)2.0, (double)provider.getCounterValue(ID_GOOD), (double)0.0);
        Assert.assertEquals((double)2.0, (double)provider.getRegisteredCounterValue(ID_GOOD), (double)0.0);
        provider.increaseCounterBy(ID_OK, value);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)value, (double)provider.getCounterValue(ID_OK), (double)0.0);
        provider.increaseCounterBy(ID_OK, value);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)valueX2, (double)provider.getCounterValue(ID_OK), (double)0.0);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounterBy(ID_OK, negValue));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)valueX2, (double)provider.getCounterValue(ID_OK), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getCounterValue(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getCounterValue(null), (double)0.0);
        provider.removeCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(ID_GOOD));
    }

    private void prepareTimerCrudTest() {
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomTimers());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(null, () -> TestUtils.oneSecondRunnable()));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_GOOD, (Runnable)null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(null, () -> TestUtils.oneSecondSupplier()));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_GOOD, (Supplier)null));
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomTimers());
    }

    @Test
    public void testTimerCrudOperations() {
        this.prepareTimerCrudTest();
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.oneSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_GOOD));
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.threeSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_GOOD));
        Assert.assertEquals((long)2L, (long)provider.getRegisteredTimerCount(ID_GOOD));
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.twoSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_GOOD));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.oneSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_OK));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.threeSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_OK));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.twoSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_OK));
        provider.recordWithTimer(ID_PASSABLE, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_PASSABLE));
        provider.recordWithTimer(ID_PASSABLE, 3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_PASSABLE));
        provider.recordWithTimer(ID_PASSABLE, 2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_PASSABLE));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_PASSABLE, -1000L, TimeUnit.MILLISECONDS));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_PASSABLE, 1000L, null));
        Assert.assertEquals((double)0.0, (double)provider.getTotalTimeFromTimer(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getTotalTimeFromTimer(null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getMaxTimeFromTimer(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getMaxTimeFromTimer(null), (double)0.0);
        Assert.assertEquals((long)0L, (long)provider.getTimerCount(ID_BAD));
        Assert.assertEquals((long)0L, (long)provider.getTimerCount(null));
        provider.removeTimer(ID_GOOD);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(ID_GOOD));
    }

    @Test
    public void setMemoryBaseUnitOk() {
        provider.setMemoryBaseUnit(CapacityBaseUnit.KILOBYTES);
        Assert.assertEquals((Object)CapacityBaseUnit.KILOBYTES, (Object)provider.getMemoryBaseUnit());
    }

    @Test
    public void setMemoryBaseUnitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.setMemoryBaseUnit(null));
    }

    @Test
    public void setDiskBaseUnitOk() {
        provider.setDiskBaseUnit(CapacityBaseUnit.MEGABYTES);
        Assert.assertEquals((Object)CapacityBaseUnit.MEGABYTES, (Object)provider.getDiskBaseUnit());
    }

    @Test
    public void setDiskBaseUnitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.setDiskBaseUnit(null));
    }

    @Test
    public void testLists() {
        this.assertList(provider.getCustomCounterList(), provider.getNumberOfCustomCounters() == 0);
        this.assertList(provider.getCustomGaugeList(), provider.getNumberOfCustomGauges() == 0);
        this.assertList(provider.getCustomTimerList(), provider.getNumberOfCustomTimers() == 0);
        this.assertList(provider.getTaggedMeterList(), false);
        this.assertList(provider.getSimpleMeterList(), false);
    }

    private void assertList(String list, boolean expectedEmpty) {
        if (expectedEmpty) {
            Assert.assertEquals((Object)"[]", (Object)list);
        } else {
            Assert.assertTrue((list.length() > 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.matches("\\[(\"\\S+\"(,\\s*\"\\S+\")*)?\\]"));
        }
    }

    @Test
    public void testJson() throws IOException {
        double gValue = 10.0;
        Counter counter = (Counter)((Counter.CounterBuilder)((Counter.CounterBuilder)MetricsFactory.buildCounter((String)"service.sent").baseUnit("tuple/s").description("Tuples sent out by a service")).tags(new String[]{"service", "SimpleReceiver", "application", "SimpleMeshApp", "device", "dev0"})).register(provider.getRegistry());
        ((Counter.CounterBuilder)((Counter.CounterBuilder)MetricsFactory.buildCounter((String)"service.received").baseUnit("tuple/s").description("Tuples received by a service")).tags(new String[]{"service", "SimpleReceiver", "application", "SimpleMeshApp", "device", "dev0"})).register(provider.getRegistry());
        ((Counter.CounterBuilder)((Counter.CounterBuilder)MetricsFactory.buildCounter((String)"system.online").baseUnit("ms").description("Time the system is online")).tags(new String[]{"service", "SimpleReceiver", "application", "SimpleMeshApp", "device", "dev2"})).register(provider.getRegistry());
        Timer timer = (Timer)((Timer.TimerBuilder)((Timer.TimerBuilder)MetricsFactory.buildTimer((String)"system.time").description("Time the system is opeating")).tags(new String[]{"service", "SimpleReceiver", "application", "SimpleMeshApp", "device", "dev2"})).register(provider.getRegistry());
        Gauge gauge = (Gauge)((Gauge.GaugeBuilder)((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)"system.value", () -> gValue).description("Some value")).tags(new String[]{"service", "SimpleReceiver", "application", "SimpleMeshApp", "device", "dev2"})).register(provider.getRegistry());
        MetricsProvider.increaseCounterBy((Counter)counter, (double)1.0);
        timer.record(() -> {
            TimeUtils.sleep((int)400);
            return "ABBA";
        });
        MetricsProvider.recordMsTime((Timer)timer, () -> 400L, () -> {});
        MetricsProvider.recordNsTime((Timer)timer, () -> 400L, () -> {});
        String json = provider.toJson("id0", false, new MeterFilter[]{MetricsFactory.acceptNameStartsWith((String)"service.sent"), MetricsFactory.denyNameStartsWith((String)"services.received")});
        this.assertMeters(json, provider.getRegistry());
        JsonObject obj = Json.createObject((String)json);
        String id = obj.getString("id");
        Assert.assertEquals((Object)"id0", (Object)id);
        if (null != id) {
            JsonObject meters = obj.getJsonObject("meters");
            for (String key : meters.keys()) {
                Iterator iter;
                Meter meter = MeterRepresentation.parseMeter((String)meters.getValue(key).toString(), (String[])new String[]{"device:dev1"});
                Assert.assertNotNull((Object)meter);
                if (meter.getId().getName().equals(counter.getId().getName())) {
                    meter.getId().getBaseUnit().equals("tuple/s");
                    meter.getId().getDescription().equals("Tuples sent out by a service");
                    Assert.assertEquals((Object)"SimpleReceiver", (Object)meter.getId().getTag("service"));
                    Assert.assertEquals((Object)"SimpleMeshApp", (Object)meter.getId().getTag("application"));
                    Assert.assertEquals((Object)"dev0", (Object)meter.getId().getTag("device"));
                    iter = meter.measure().iterator();
                    Assert.assertTrue((boolean)iter.hasNext());
                    Assert.assertEquals((double)1.0, (double)((Measurement)iter.next()).getValue(), (double)0.001);
                    continue;
                }
                if (meter.getId().getName().equals(timer.getId().getName())) {
                    Assert.assertEquals((Object)"dev2", (Object)meter.getId().getTag("device"));
                    iter = meter.measure().iterator();
                    boolean foundCount = false;
                    boolean foundTotalTime = false;
                    while (iter.hasNext()) {
                        Measurement m = (Measurement)iter.next();
                        if (Statistic.COUNT.name().equals(m.getStatistic().name())) {
                            foundCount = true;
                            Assert.assertTrue((m.getValue() > 0.0 ? 1 : 0) != 0);
                            continue;
                        }
                        if (!Statistic.TOTAL_TIME.name().equals(m.getStatistic().name())) continue;
                        foundTotalTime = true;
                        Assert.assertTrue((m.getValue() > 0.0 ? 1 : 0) != 0);
                    }
                    Assert.assertTrue((foundCount && foundTotalTime ? 1 : 0) != 0);
                    continue;
                }
                if (!meter.getId().getName().equals(gauge.getId().getName())) continue;
                Assert.assertEquals((Object)"dev2", (Object)meter.getId().getTag("device"));
                for (Measurement m : meter.measure()) {
                    if (!Statistic.VALUE.name().equals(m.getStatistic().name())) continue;
                    Assert.assertEquals((double)gValue, (double)m.getValue(), (double)0.01);
                }
            }
        }
    }

    private void assertMeters(String json, MeterRegistry registry) throws IOException {
        JsonObject obj = Json.createObject((String)json);
        String id = obj.getString("id");
        Assert.assertNotNull((Object)id);
        Assert.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        JsonObject meters = obj.getJsonObject("meters");
        for (String key : meters.keys()) {
            Meter meter = MeterRepresentation.parseMeter((String)meters.getValue(key).toString(), (String[])new String[]{"device:abcd"});
            Meter s = registry.getMeter(meter.getName());
            Assert.assertNotNull((Object)s);
            Assert.assertTrue((meter.getId().getType() == s.getId().getType() ? 1 : 0) != 0);
            List mMeasure = CollectionUtils.toList(meter.measure().iterator());
            List sMeasure = CollectionUtils.toList(s.measure().iterator());
            Assert.assertEquals((long)mMeasure.size(), (long)sMeasure.size());
            for (int i = 0; i < mMeasure.size(); ++i) {
                Measurement mM = (Measurement)mMeasure.get(i);
                Measurement sM = (Measurement)sMeasure.get(i);
                Assert.assertEquals((double)mM.getValue(), (double)sM.getValue(), (double)0.01);
                Assert.assertEquals((Object)mM.getStatistic(), (Object)sM.getStatistic());
            }
        }
    }

    @Test
    public void testInclude() {
        Assert.assertTrue((boolean)MetricsProvider.include((String)"jvm_memory_pool_collection_max_bytes", (MeterFilter[])MetricsProvider.DEFAULT_METER_FILTERS));
        Assert.assertFalse((boolean)MetricsProvider.include((String)"jvm_memory_pool_collection_max_bytes".replaceAll("_", "."), (MeterFilter[])MetricsProvider.DEFAULT_METER_FILTERS));
    }

    @Test
    public void testAppend() {
        int i;
        MeterFilter add = MetricsFactory.deny();
        MeterFilter[] t = MetricsProvider.append((MeterFilter[])MetricsProvider.DEFAULT_METER_FILTERS, (MeterFilter[])new MeterFilter[]{add});
        Assert.assertTrue((t.length == MetricsProvider.DEFAULT_METER_FILTERS.length + 1 ? 1 : 0) != 0);
        for (i = 0; i < t.length; ++i) {
            Assert.assertNotNull((Object)t[i]);
        }
        for (i = 0; i < MetricsProvider.DEFAULT_METER_FILTERS.length; ++i) {
            Assert.assertTrue((t[i] == MetricsProvider.DEFAULT_METER_FILTERS[i] ? 1 : 0) != 0);
        }
        Assert.assertTrue((t[t.length - 1] == add ? 1 : 0) != 0);
    }
}

