/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportConverterFactory;
import de.iip_ecosphere.platform.services.environment.services.TransportToWsConverter;
import de.iip_ecosphere.platform.services.environment.services.WsTransportConverterFactory;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.services.TraceToAasServiceMain;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class TransportToWsConverterTest
extends TestWithQpid {
    @Test
    public void testConverter() {
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        this.qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        this.qpid.start();
        AtomicInteger count = new AtomicInteger();
        TransportSetup transSetup = new TransportSetup();
        transSetup.setHost("localhost");
        transSetup.setPort(broker.getPort());
        transSetup.setAuthenticationKey("amqp");
        Transport.setTransportSetup(() -> transSetup);
        Endpoint converterEndpoint = new Endpoint(Schema.WS, "localhost", NetUtils.getEphemeralPort(), "/status");
        Server converterServer = TransportToWsConverter.createServer((ServerAddress)converterEndpoint).start();
        TransportToWsConverter converter = new TransportToWsConverter("Trace", TraceRecord.class, converterEndpoint);
        converter.start(null);
        Assert.assertEquals((Object)converterEndpoint, (Object)converter.getEndpoint());
        TransportConverter.Watcher watcher = converter.createWatcher(0);
        watcher.setConsumer(t -> count.incrementAndGet());
        watcher.start();
        int[] img = new int[]{128, 128, 64, 12, 0, 8};
        TraceToAasServiceMain.MyData data = new TraceToAasServiceMain.MyData(img);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("source", "sending", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "receiving", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "sending", (Object)data));
        TimeUtils.sleep((int)1500);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("receiver", "receiving", (Object)data));
        TimeUtils.sleep((int)1500);
        watcher.stop();
        converter.stop();
        converterServer.stop(true);
        Assert.assertTrue((count.get() > 3 ? 1 : 0) != 0);
        this.qpid.stop(true);
        Transport.releaseConnector((boolean)false);
    }

    @Test
    public void testFactory() {
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        this.qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        this.qpid.start();
        Assert.assertNotNull((Object)TransportConverterFactory.getInstance());
        AtomicInteger count = new AtomicInteger();
        TransportSetup transSetup = new TransportSetup();
        transSetup.setHost("localhost");
        transSetup.setPort(broker.getPort());
        transSetup.setAuthenticationKey("amqp");
        transSetup.setGatewayPort(NetUtils.getEphemeralPort());
        Transport.setTransportSetup(() -> transSetup);
        String path = "/status";
        AasPartRegistry.AasSetup aas = null;
        WsTransportConverterFactory factory = WsTransportConverterFactory.INSTANCE;
        Server converterServer = factory.createServer(aas, transSetup).start();
        TransportConverter converter = factory.createConverter(aas, transSetup, "Trace", "/status", null, TraceRecord.class);
        converter.start(aas);
        Assert.assertNotNull((Object)converter.getEndpoint());
        TransportConverter.Watcher watcher = factory.createWatcher(aas, transSetup, "/status", null, TraceRecord.class, 0);
        watcher.setConsumer(t -> count.incrementAndGet());
        watcher.start();
        int[] img = new int[]{128, 128, 64, 12, 0, 8};
        TraceToAasServiceMain.MyData data = new TraceToAasServiceMain.MyData(img);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("source", "sending", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "receiving", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "sending", (Object)data));
        TimeUtils.sleep((int)1500);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("receiver", "receiving", (Object)data));
        TimeUtils.sleep((int)700);
        watcher.stop();
        converter.stop();
        converterServer.stop(true);
        Assert.assertEquals((long)4L, (long)count.get());
        this.qpid.stop(true);
        Transport.releaseConnector((boolean)false);
    }
}

