/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.util.concurrent.ExecutionException;

public interface GenericMultiTypeService
extends Service {
    public <I> void registerInputTypeTranslator(Class<I> var1, String var2, TypeTranslator<I, String> var3);

    public <O> void registerOutputTypeTranslator(Class<O> var1, String var2, TypeTranslator<String, O> var3);

    public <O> void attachIngestor(Class<O> var1, String var2, DataIngestor<O> var3);

    public <I> void process(String var1, I var2) throws ExecutionException;

    public <I, O> O processSync(String var1, I var2, String var3) throws ExecutionException;

    default public <I> void processQuiet(String inTypeName, I data) {
        try {
            this.process(inTypeName, data);
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Processing failed: " + e.getMessage());
        }
    }

    default public <I, O> O processSyncQuiet(String inTypeName, I data, String outTypeName) {
        try {
            return this.processSync(inTypeName, data, outTypeName);
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Processing failed: " + e.getMessage());
            return null;
        }
    }
}

