/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public enum ServiceState {
    AVAILABLE,
    DEPLOYING,
    CREATED,
    STARTING,
    RUNNING,
    FAILED,
    STOPPING,
    STOPPED,
    PASSIVATING,
    PASSIVATED,
    MIGRATING,
    ACTIVATING,
    RECOVERING,
    RECOVERED,
    RECONFIGURING,
    UNDEPLOYING,
    UNKNOWN;

    private static Map<ServiceState, Set<ServiceState>> validTransitions;

    private static void addValidTransition(ServiceState source, ServiceState ... targets) {
        Set<ServiceState> validTrans = validTransitions.get((Object)source);
        if (null == validTrans) {
            validTrans = new HashSet<ServiceState>();
            validTransitions.put(source, validTrans);
        }
        for (ServiceState t : targets) {
            validTrans.add(t);
        }
    }

    public boolean isValidTransition(ServiceState target) {
        boolean result = false;
        if (FAILED == target || UNKNOWN == target || this == target) {
            result = true;
        } else {
            Set<ServiceState> validTargets = validTransitions.get((Object)this);
            if (null != validTargets) {
                result = validTargets.contains((Object)target);
            }
        }
        return result;
    }

    public static void validateTransition(ServiceState source, ServiceState target) throws ExecutionException {
        if (null == source) {
            throw new ExecutionException("No source state given: null", null);
        }
        if (!source.isValidTransition(target)) {
            throw new ExecutionException("State transition from " + String.valueOf((Object)source) + " to " + String.valueOf((Object)target) + " is not valid", null);
        }
    }

    public static String toString(ServiceState state) {
        return ServiceState.toString(state, UNKNOWN);
    }

    public static String toString(ServiceState state, ServiceState dflt) {
        return (null == state ? dflt : state).toString();
    }

    static {
        validTransitions = new HashMap<ServiceState, Set<ServiceState>>();
        ServiceState.addValidTransition(UNKNOWN, AVAILABLE);
        ServiceState.addValidTransition(AVAILABLE, DEPLOYING, CREATED, STARTING, STOPPING, UNDEPLOYING);
        ServiceState.addValidTransition(STARTING, STOPPING);
        ServiceState.addValidTransition(DEPLOYING, CREATED, STARTING, STOPPING);
        ServiceState.addValidTransition(CREATED, STARTING);
        ServiceState.addValidTransition(STARTING, RUNNING);
        ServiceState.addValidTransition(RUNNING, STOPPING, RECONFIGURING, PASSIVATING);
        ServiceState.addValidTransition(RECONFIGURING, RUNNING, PASSIVATING);
        ServiceState.addValidTransition(PASSIVATING, PASSIVATED);
        ServiceState.addValidTransition(PASSIVATED, MIGRATING, ACTIVATING);
        ServiceState.addValidTransition(MIGRATING, ACTIVATING);
        ServiceState.addValidTransition(ACTIVATING, RUNNING);
        ServiceState.addValidTransition(FAILED, RECOVERING, STOPPING, STOPPED);
        ServiceState.addValidTransition(RECOVERING, RECOVERED);
        ServiceState.addValidTransition(RECOVERED, RUNNING);
        ServiceState.addValidTransition(STOPPING, STOPPED, DEPLOYING);
        ServiceState.addValidTransition(STOPPED, AVAILABLE, DEPLOYING, STARTING, STOPPING);
        ServiceState.addValidTransition(UNDEPLOYING, UNKNOWN);
    }
}

