/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.testing;

import de.iip_ecosphere.platform.services.environment.testing.DataRecorder;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class DataRecorderTest {
    @Test
    public void testRecorderValidFile() throws IOException {
        File f = File.createTempFile("iip-test", ".txt");
        this.testRecorder(f, new DataRecorder(f, DataRecorder.JSON_FORMATTER), DataRecorder.JSON_FORMATTER);
        f.delete();
    }

    @Test
    public void testRecorderInvalidFile() {
        this.testRecorder(null, new DataRecorder(new File(""), DataRecorder.JSON_FORMATTER), DataRecorder.JSON_FORMATTER);
    }

    private void testRecorder(File file, DataRecorder recorder, Function<Object, String> formatter) {
        Data data = new Data();
        data.setValue(42);
        String text = formatter.apply(data);
        recorder.record(null, (Object)data);
        recorder.record("channel", (Object)data);
        recorder.emitChannel(false);
        recorder.record(null, (Object)data);
        recorder.record("channel", (Object)data);
        recorder.close();
        if (null != file) {
            try {
                String contents = FileUtils.readFileToString((File)file);
                contents = contents.replace("\n", "*").replace("\r", "");
                Assert.assertEquals((Object)(text + "*channel: " + text + "*" + text + "*" + text + "*"), (Object)contents);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception: " + e.getMessage()));
            }
        }
    }

    public static class Data {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

