/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MonitoredTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.metrics.MeterRegistry;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredTranslatingProtocolAdapterTest {
    @Test
    public void testAdapterWithLog() {
        File log = new File(FileUtils.getTempDirectory(), "monTest.log");
        log.deleteOnExit();
        MonitoredTranslatingProtocolAdapterTest.testAdapter(log);
    }

    @Test
    public void testAdapterWithoutLog() {
        MonitoredTranslatingProtocolAdapterTest.testAdapter(null);
    }

    private static void testAdapter(File log) {
        MeterRegistry reg = MetricsFactory.getInstance().createRegistry();
        MetricsProvider metrics = new MetricsProvider(reg);
        MonitoredTranslatingProtocolAdapter adapter = new MonitoredTranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new ConnectorOutTranslator(), (ConnectorInputTypeTranslator)new ConnectorInTranslator(), metrics, log);
        int max = 10;
        for (int i = 0; i < 10; ++i) {
            try {
                adapter.adaptInput((Object)((ConnectorData)adapter.adaptOutput("", (Object)"test")));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Timer iTimer = reg.getTimer("adaptInputTime");
        double tmp = iTimer.mean(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)(tmp + " not in range"), (140.0 <= tmp && tmp <= 500.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)iTimer.count());
        Timer oTimer = reg.getTimer("adaptOutputTime");
        tmp = oTimer.mean(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)(tmp + " not in range"), (90.0 <= tmp && tmp <= 550.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)oTimer.count());
        if (null != log) {
            Assert.assertTrue((boolean)log.exists());
            Assert.assertTrue((log.length() > 0L ? 1 : 0) != 0);
            try {
                System.out.println("LOG:");
                System.out.println(FileUtils.readFileToString((File)log, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException t) {
                t.printStackTrace();
            }
            FileUtils.deleteQuietly((File)log);
        }
    }

    private static class ConnectorOutTranslator
    implements ConnectorOutputTypeTranslator<String, ConnectorData> {
        private ConnectorOutTranslator() {
        }

        public ConnectorData to(String source) throws IOException {
            TimeUtils.sleep((int)100);
            ConnectorData result = new ConnectorData();
            result.data = source;
            return result;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public void initializeModelAccess() throws IOException {
        }

        public Class<? extends String> getSourceType() {
            return String.class;
        }

        public Class<? extends ConnectorData> getTargetType() {
            return ConnectorData.class;
        }
    }

    private static class ConnectorInTranslator
    implements ConnectorInputTypeTranslator<ConnectorData, String> {
        private ConnectorInTranslator() {
        }

        public String from(ConnectorData data) throws IOException {
            TimeUtils.sleep((int)150);
            return data.data;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public Class<? extends String> getSourceType() {
            return String.class;
        }

        public Class<? extends ConnectorData> getTargetType() {
            return ConnectorData.class;
        }
    }

    private static class ConnectorData {
        private String data;

        private ConnectorData() {
        }
    }
}

