/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.ElementContainer;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class TransportConverter<T> {
    public static final String NAME_COLL_ENDPOINTS = "endpoints";
    public static final String NAME_PROP_SCHEMA = "schema";
    public static final String NAME_PROP_HOST = "host";
    public static final String NAME_PROP_PORT = "port";
    public static final String NAME_PROP_PATH = "path";
    public static final String NAME_PROP_URI = "uri";
    protected static final String PREFIX_GETTER = "get";
    private TraceRecordReceptionCallback callback;
    private List<IOConsumer<T>> notifier = new ArrayList<IOConsumer<T>>();
    private String transportStream;
    private Class<T> dataType;
    private Predicate<T> handleNewFilter = d -> true;
    private Supplier<Boolean> aasEnabledSupplier;
    private Set<String> excludedFields = new HashSet<String>();
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    public TransportConverter(String transportStream, Class<T> dataType) {
        this(transportStream, dataType, null);
    }

    public TransportConverter(String transportStream, Class<T> dataType, Predicate<T> handleNewFilter) {
        this.transportStream = transportStream;
        this.dataType = dataType;
        this.setHandleNewFilter(handleNewFilter);
    }

    public void setHandleNewFilter(Predicate<T> handleNewFilter) {
        this.handleNewFilter = null == handleNewFilter ? d -> true : handleNewFilter;
    }

    public void setExcludedFields(Set<String> excludedFields) {
        this.excludedFields.clear();
        if (excludedFields != null) {
            this.excludedFields.addAll(excludedFields);
        }
    }

    public boolean isExcludedField(String fieldName) {
        return this.excludedFields.contains(fieldName);
    }

    protected String[] getExcludedFieldsArray() {
        return this.excludedFields.toArray(new String[this.excludedFields.size()]);
    }

    public void addNotifier(IOConsumer<T> notifier) {
        if (null != notifier) {
            this.notifier.add(notifier);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No notifier given. Ignoring call.");
        }
    }

    protected abstract void handleNew(T var1);

    private void handleNewAndNotify(T data) {
        for (IOConsumer<T> n : this.notifier) {
            try {
                n.accept(data);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot inform notifier: {}", (Object)e.getMessage());
            }
        }
        if (this.handleNewFilter.test(data)) {
            this.handleNew(data);
        }
    }

    protected Object getValue(Object object, Method method, String field) {
        Object result;
        try {
            result = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            result = null;
            LoggerFactory.getLogger(this.getClass()).error("Cannot obtain value of operation {}/field {} of class {} to AAS: {}", new Object[]{method.getName(), field, method.getDeclaringClass().getName(), e.getMessage()});
        }
        return result;
    }

    protected String mapPayloadType(Class<?> cls) {
        return cls.getName();
    }

    protected static boolean isGetter(Method method) {
        int modifier = method.getModifiers();
        boolean pubNonStatic = Modifier.isPublic(modifier) && !Modifier.isStatic(modifier);
        return method.getName().startsWith(PREFIX_GETTER) && method.getParameterCount() == 0 && pubNonStatic;
    }

    protected final Class<T> getType() {
        return this.dataType;
    }

    public void initializeSubmodel(Submodel.SubmodelBuilder smBuilder) {
    }

    public void start(AasPartRegistry.AasSetup aasSetup) {
        this.callback = new TraceRecordReceptionCallback();
        TransportConnector conn = Transport.createConnector();
        if (null != conn) {
            try {
                conn.setReceptionCallback(this.transportStream, (ReceptionCallback)this.callback);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Registring transport callback: " + e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).error("No transport setup, will not listen to trace records.");
        }
    }

    protected boolean isAasEnabled() {
        return null == this.aasEnabledSupplier ? true : this.aasEnabledSupplier.get();
    }

    public void setAasEnabledSupplier(Supplier<Boolean> enabledSupplier) {
        if (null != enabledSupplier) {
            this.aasEnabledSupplier = enabledSupplier;
        }
    }

    public boolean isAasStarted() {
        return true;
    }

    public void setTimeout(long timeout) {
    }

    public void setCleanupTimeout(long cleanupTimeout) {
    }

    public boolean cleanup() {
        return true;
    }

    public void stop() {
        this.executorService.shutdown();
        try {
            TransportConnector conn = Transport.getConnector();
            if (null != conn) {
                conn.detachReceptionCallback(this.transportStream, (ReceptionCallback)this.callback);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Detaching transport connector: " + e.getMessage());
        }
    }

    public Endpoint getEndpoint() {
        return null;
    }

    public boolean isTraceInAas() {
        return false;
    }

    public abstract Watcher<T> createWatcher(int var1);

    public static SubmodelElementCollection getEndpoint(ElementContainer parent, String path) {
        SubmodelElementCollection endpoint = null;
        SubmodelElementCollection endpoints = parent.getSubmodelElementCollection(NAME_COLL_ENDPOINTS);
        if (null != endpoints) {
            endpoint = parent.getSubmodelElementCollection(TransportConverter.toAasEndpointId(path));
        }
        return endpoint;
    }

    public static Endpoint getEndpoint(SubmodelElementCollection endpoint) {
        Endpoint result = null;
        if (null != endpoint) {
            String schema = AasUtils.getPropertyValueAsStringSafe((ElementsAccess)endpoint, (String)NAME_PROP_SCHEMA, null);
            String host = AasUtils.getPropertyValueAsStringSafe((ElementsAccess)endpoint, (String)NAME_PROP_HOST, null);
            int port = AasUtils.getPropertyValueAsIntegerSafe((ElementsAccess)endpoint, (String)NAME_PROP_PORT, (Integer)10000);
            String path = AasUtils.getPropertyValueAsStringSafe((ElementsAccess)endpoint, (String)NAME_PROP_PATH, null);
            if (null != schema && null != host && null != path) {
                try {
                    result = new Endpoint(Schema.valueOf((String)schema), host, port, path);
                }
                catch (IllegalArgumentException e) {
                    LoggerFactory.getLogger(TransportConverter.class).warn("Cannot convert schema {}: {}", (Object)schema, (Object)e.getMessage());
                }
            } else {
                LoggerFactory.getLogger(TransportConverter.class).warn("Cannot create endpoint object as information is missing (schema: {}, host: {}, port: {}, path: {})", new Object[]{schema, host, port, path});
            }
        } else {
            LoggerFactory.getLogger(TransportConverter.class).warn("Cannot create endpoint object as submodel element collection is null");
        }
        return result;
    }

    public static String toAasEndpointId(String path) {
        String id = path;
        while (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (id.length() == 0) {
            id = String.valueOf(System.currentTimeMillis());
        }
        return AasUtils.fixId((String)id);
    }

    public static void addEndpointToAas(SubmodelElementContainerBuilder smBuilder, Endpoint endpoint) {
        if (null != endpoint) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder endpoints = smBuilder.createSubmodelElementCollectionBuilder(NAME_COLL_ENDPOINTS);
            SubmodelElementCollection.SubmodelElementCollectionBuilder eBuilder = smBuilder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)TransportConverter.toAasEndpointId(endpoint.getEndpoint())));
            eBuilder.createPropertyBuilder(NAME_PROP_SCHEMA).setValue(Type.STRING, (Object)endpoint.getSchema().name()).build();
            eBuilder.createPropertyBuilder(NAME_PROP_HOST).setValue(Type.STRING, (Object)endpoint.getHost()).build();
            eBuilder.createPropertyBuilder(NAME_PROP_PORT).setValue(Type.INT32, (Object)endpoint.getPort()).build();
            eBuilder.createPropertyBuilder(NAME_PROP_PATH).setValue(Type.STRING, (Object)endpoint.getEndpoint()).build();
            eBuilder.createPropertyBuilder(NAME_PROP_URI).setValue(Type.STRING, (Object)endpoint.toUri()).build();
            eBuilder.build();
            endpoints.build();
        }
    }

    private class TraceRecordReceptionCallback
    implements ReceptionCallback<T> {
        private TraceRecordReceptionCallback() {
        }

        public void received(T data) {
            TransportConverter.this.executorService.submit(() -> TransportConverter.this.handleNewAndNotify(data));
        }

        public Class<T> getType() {
            return TransportConverter.this.dataType;
        }
    }

    public static interface Watcher<T> {
        public Watcher<T> start();

        public Watcher<T> stop();

        public void setConsumer(Consumer<T> var1);
    }

    public static class ConverterInstances<T> {
        private Server server;
        private TransportConverter<T> converter;

        public ConverterInstances(TransportConverter<T> converter) {
            this(null, converter);
        }

        protected ConverterInstances(Server server, TransportConverter<T> converter) {
            this.server = server;
            this.converter = converter;
        }

        public Server getServer() {
            return this.server;
        }

        public TransportConverter<T> getConverter() {
            return this.converter;
        }
    }
}

