/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.AbstractArtifactDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.TypedDataDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

public abstract class AbstractServiceManager<A extends AbstractArtifactDescriptor<S>, S extends AbstractServiceDescriptor<A>>
implements ServiceManager {
    private Map<String, A> artifacts = Collections.synchronizedMap(new HashMap());

    protected abstract Predicate<TypedDataConnectorDescriptor> getAvailablePredicate();

    @Override
    public Set<String> getArtifactIds() {
        return this.artifacts.keySet();
    }

    public Collection<A> getArtifacts() {
        return this.artifacts.values();
    }

    @Override
    public Set<String> getServiceIds() {
        HashSet<String> result = new HashSet<String>();
        for (AbstractArtifactDescriptor a : this.getArtifacts()) {
            result.addAll(a.getServiceIds());
        }
        return result;
    }

    public Collection<S> getServices() {
        HashSet result = new HashSet();
        for (AbstractArtifactDescriptor a : this.getArtifacts()) {
            result.addAll(a.getServices());
        }
        return result;
    }

    public A getArtifact(String artifactId) {
        return (A)(null == artifactId ? null : (AbstractArtifactDescriptor)this.artifacts.get(artifactId));
    }

    public S getService(String serviceId) {
        AbstractArtifactDescriptor a;
        ServiceDescriptor result = null;
        Iterator<A> iterator = this.getArtifacts().iterator();
        while (iterator.hasNext() && null == (result = (a = (AbstractArtifactDescriptor)iterator.next()).getService(serviceId))) {
        }
        return (S)result;
    }

    @Override
    public ServiceState getServiceState(String serviceId) {
        ServiceState result = ServiceState.UNKNOWN;
        ServiceDescriptor service = this.getService(serviceId);
        if (null != service) {
            result = ((AbstractServiceDescriptor)service).getState();
        }
        return result;
    }

    protected String addArtifact(String artifactId, A descriptor) throws ExecutionException {
        AbstractServiceManager.checkId(artifactId, "artifactId");
        if (this.artifacts.containsKey(artifactId)) {
            throw new ExecutionException("Artifact id '" + artifactId + "' is already known", null);
        }
        this.artifacts.put(artifactId, descriptor);
        ServicesAas.notifyArtifactAdded(descriptor);
        return artifactId;
    }

    @Override
    public void removeArtifact(String artifactId) throws ExecutionException {
        AbstractServiceManager.checkId(artifactId, "artifactId");
        if (!this.artifacts.containsKey(artifactId)) {
            String aId = artifactId;
            Optional<AbstractArtifactDescriptor> fallback = this.artifacts.values().stream().filter(a -> aId.equals(a.getUri().toString())).findAny();
            if (fallback.isPresent()) {
                artifactId = fallback.get().getId();
            }
        }
        if (!this.artifacts.containsKey(artifactId)) {
            throw new ExecutionException("Artifact id '" + artifactId + "' is not known. Cannot remove artifact.", null);
        }
        AbstractArtifactDescriptor aDesc = (AbstractArtifactDescriptor)this.artifacts.remove(artifactId);
        ServicesAas.notifyArtifactRemoved(aDesc);
    }

    protected static final boolean isValidId(String id) {
        return null != id && id.length() > 0;
    }

    protected static final boolean isValidIdBut(String id, String butId) {
        return AbstractServiceManager.isValidId(id) && !id.equals(butId);
    }

    protected static void checkId(String id, String text) throws ExecutionException {
        if (!AbstractServiceManager.isValidId(id)) {
            throw new ExecutionException(text + " must be given (not null or empty)", null);
        }
    }

    @Override
    public void switchToService(String serviceId, String targetId) throws ExecutionException {
        AbstractServiceManager.checkId(serviceId, "id");
        AbstractServiceManager.checkId(serviceId, "targetId");
        if (!serviceId.equals(targetId)) {
            this.stopService(serviceId);
            this.startService(targetId);
        }
    }

    @Override
    public void migrateService(String serviceId, String resourceId) throws ExecutionException {
        AbstractServiceManager.checkId(serviceId, "serviceId");
        S cnt = this.getServiceDescriptor(serviceId, "serviceId", "migrate");
        if (ServiceState.RUNNING != ((AbstractServiceDescriptor)cnt).getState()) {
            throw new ExecutionException("Service " + serviceId + " is in state " + String.valueOf(((AbstractServiceDescriptor)cnt).getState()) + ". Cannot migrate service.", null);
        }
        this.stopService(serviceId);
    }

    @Override
    public void passivateService(String serviceId) throws ExecutionException {
        S service = this.getServiceDescriptor(serviceId, "serviceId", "passivate");
        ServiceStub stub = ((AbstractServiceDescriptor)service).getStub();
        if (ServiceState.RUNNING != ((AbstractServiceDescriptor)service).getState() && null != stub) {
            throw new ExecutionException("Cannot passivate service '" + serviceId + "'as it is in state " + String.valueOf(((AbstractServiceDescriptor)service).getState()) + "/not running.", null);
        }
        this.setState((ServiceDescriptor)service, ServiceState.PASSIVATING);
        stub.passivate();
        this.setState((ServiceDescriptor)service, ServiceState.PASSIVATED);
    }

    @Override
    public void activateService(String serviceId) throws ExecutionException {
        S service = this.getServiceDescriptor(serviceId, "serviceId", "activate");
        ServiceStub stub = ((AbstractServiceDescriptor)service).getStub();
        if (ServiceState.PASSIVATED != ((AbstractServiceDescriptor)service).getState() && null != stub) {
            throw new ExecutionException("Cannot passivate as service is in state " + String.valueOf(((AbstractServiceDescriptor)service).getState()), null);
        }
        stub.activate();
        this.setState((ServiceDescriptor)service, ServiceState.RUNNING);
    }

    @Override
    public void reconfigureService(String serviceId, Map<String, String> values) throws ExecutionException {
        S service = this.getServiceDescriptor(serviceId, "serviceId", "reconfigure");
        ServiceStub stub = ((AbstractServiceDescriptor)service).getStub();
        if (stub == null) {
            throw new ExecutionException("Cannot reconfigure service '" + serviceId + "'as it is in state " + String.valueOf(((AbstractServiceDescriptor)service).getState()) + "/not running.", null);
        }
        ServiceState state = ((AbstractServiceDescriptor)service).getState();
        this.setState((ServiceDescriptor)service, ServiceState.RECONFIGURING);
        stub.reconfigure(values);
        this.setState((ServiceDescriptor)service, state);
    }

    protected ServiceStub getStub(S service) {
        return ((AbstractServiceDescriptor)service).getStub();
    }

    protected A getArtifactDescriptor(String artifactId, String idText, String activityText) throws ExecutionException {
        AbstractServiceManager.checkId(artifactId, idText);
        AbstractArtifactDescriptor result = (AbstractArtifactDescriptor)this.artifacts.get(artifactId);
        if (null == result) {
            throw new ExecutionException("Artifact id '" + artifactId + "' is not known. Cannot " + activityText + " service.", null);
        }
        return (A)result;
    }

    protected S getServiceDescriptor(String serviceId, String idText, String activityText) throws ExecutionException {
        AbstractServiceManager.checkId(serviceId, idText);
        ServiceDescriptor result = this.getService(serviceId);
        if (null == result) {
            throw new ExecutionException("Service id '" + serviceId + "' is not known. Cannot " + activityText + " service.", null);
        }
        return (S)result;
    }

    @Override
    public void setServiceState(String serviceId, ServiceState state) throws ExecutionException {
        this.setState((ServiceDescriptor)this.getServiceDescriptor(serviceId, "serviceId", "setState"), state);
    }

    protected void setState(ServiceDescriptor service, ServiceState state) throws ExecutionException {
        ServiceState old = service.getState();
        service.setState(state);
        ServicesAas.notifyServiceStateChanged(old, state, service);
    }

    @Override
    public List<TypedDataDescriptor> getParameters(String serviceId) {
        List<TypedDataDescriptor> result = null;
        ServiceDescriptor service = this.getService(serviceId);
        if (null != service) {
            result = ((AbstractServiceDescriptor)service).getParameters();
        }
        return result;
    }

    @Override
    public List<TypedDataConnectorDescriptor> getInputDataConnectors(String serviceId) {
        List<TypedDataConnectorDescriptor> result = null;
        ServiceDescriptor service = this.getService(serviceId);
        if (null != service) {
            result = ((AbstractServiceDescriptor)service).getInputDataConnectors();
        }
        return result;
    }

    @Override
    public List<TypedDataConnectorDescriptor> getOutputDataConnectors(String serviceId) {
        List<TypedDataConnectorDescriptor> result = null;
        ServiceDescriptor service = this.getService(serviceId);
        if (null != service) {
            result = ((AbstractServiceDescriptor)service).getOutputDataConnectors();
        }
        return result;
    }

    protected String[] sortByDependency(String[] serviceIds, boolean start) {
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        for (String s2 : serviceIds) {
            services.add(this.getService(s2));
        }
        Predicate<TypedDataConnectorDescriptor> available = start ? this.getAvailablePredicate() : d -> true;
        return (String[])AbstractServiceManager.sortByDependency(services, this.getServices(), available, !start).stream().map(s -> s.getId()).toArray(String[]::new);
    }

    public static <S extends ServiceDescriptor> List<S> sortByDependency(List<S> services, Collection<? extends ServiceDescriptor> localServices, Predicate<TypedDataConnectorDescriptor> available, boolean reverse) {
        int before;
        ArrayList<ServiceDescriptor> result = new ArrayList<ServiceDescriptor>();
        HashSet<String> ensembleConnections = new HashSet<String>();
        for (ServiceDescriptor s : services) {
            ensembleConnections.addAll(AbstractServiceDescriptor.ensembleConnectorNames(s));
        }
        Set<String> internalConnections = AbstractServiceDescriptor.internalConnectorNames(localServices);
        internalConnections.removeAll(ensembleConnections);
        HashSet<ServiceDescriptor> processed = new HashSet<ServiceDescriptor>();
        HashSet<String> avail = new HashSet<String>();
        boolean externalPrio = true;
        do {
            before = result.size();
            for (ServiceDescriptor sd : services) {
                boolean ok = true;
                if (processed.contains(sd)) continue;
                if (null != sd.getEnsembleLeader()) {
                    ok = processed.contains(sd.getEnsembleLeader());
                } else {
                    for (TypedDataConnectorDescriptor out : sd.getOutputDataConnectors()) {
                        String outName = out.getName();
                        if (externalPrio && internalConnections.contains(outName)) {
                            ok = false;
                            break;
                        }
                        if (ensembleConnections.contains(outName) || avail.contains(outName)) continue;
                        ok = available.test(out);
                        if (ok) {
                            avail.add(outName);
                            continue;
                        }
                        LoggerFactory.getLogger(AbstractServiceManager.class).warn("Service prerequisite " + String.valueOf(out) + " not available from service " + sd.getId());
                        break;
                    }
                }
                if (!ok) continue;
                result.add(sd);
                processed.add(sd);
            }
            externalPrio = false;
        } while (before != result.size() && result.size() != services.size());
        for (ServiceDescriptor sd : services) {
            if (processed.contains(sd)) continue;
            result.add(sd);
        }
        if (reverse) {
            Collections.reverse(result);
        }
        return result;
    }

    private static final boolean containsIdSafe(Collection<String> coll, String id) {
        boolean result = AbstractServiceManager.isValidId(id) ? coll.contains(id) : false;
        return result;
    }

    public static Set<TypedDataConnection> determineExternalConnections(ServiceManager mgr, String ... serviceIds) {
        HashSet<TypedDataConnection> result = new HashSet<TypedDataConnection>();
        Set ids = CollectionUtils.addAll(new HashSet(), (Object[])serviceIds);
        HashSet<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();
        for (String string : serviceIds) {
            ServiceDescriptor service = mgr.getService(string);
            if (null == service || !service.isTopLevel()) continue;
            artifacts.add(service.getArtifact());
            for (TypedDataConnectorDescriptor c : service.getDataConnectors()) {
                if (!AbstractServiceManager.isValidIdBut(c.getService(), string) || AbstractServiceManager.containsIdSafe(ids, c.getService())) continue;
                result.add(new TypedDataConnection(c, null, service.getInputDataConnectors().contains(c)));
            }
        }
        for (ArtifactDescriptor a : artifacts) {
            for (ServiceDescriptor serviceDescriptor : a.getServices()) {
                if (!serviceDescriptor.isTopLevel() || AbstractServiceManager.containsIdSafe(ids, serviceDescriptor.getId())) continue;
                for (TypedDataConnectorDescriptor c : serviceDescriptor.getDataConnectors()) {
                    if (serviceDescriptor.getId().equals(c.getService()) || !AbstractServiceManager.containsIdSafe(ids, c.getService())) continue;
                    result.add(new TypedDataConnection(c, serviceDescriptor.getId(), serviceDescriptor.getInputDataConnectors().contains(c)));
                }
            }
        }
        return result;
    }

    public static Set<TypedDataConnection> determineInternalConnections(ServiceManager mgr, String ... serviceIds) {
        HashSet<TypedDataConnection> result = new HashSet<TypedDataConnection>();
        Set ids = CollectionUtils.addAll(new HashSet(), (Object[])serviceIds);
        HashSet<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();
        for (String string : serviceIds) {
            ServiceDescriptor service = mgr.getService(string);
            if (null == service || !service.isTopLevel()) continue;
            artifacts.add(service.getArtifact());
        }
        for (ArtifactDescriptor a : artifacts) {
            for (ServiceDescriptor serviceDescriptor : a.getServices()) {
                if (!serviceDescriptor.isTopLevel()) continue;
                if (AbstractServiceManager.containsIdSafe(ids, serviceDescriptor.getId())) {
                    for (TypedDataConnectorDescriptor c : serviceDescriptor.getOutputDataConnectors()) {
                        result.add(new TypedDataConnection(c, null, false));
                    }
                }
                for (TypedDataConnectorDescriptor c : serviceDescriptor.getInputDataConnectors()) {
                    if (!AbstractServiceManager.containsIdSafe(ids, c.getService())) continue;
                    result.add(new TypedDataConnection(c, null, true));
                }
            }
        }
        return result;
    }

    public static Set<TypedDataConnection> determineFunctionalConnections(ServiceManager mgr, String ... serviceIds) {
        HashSet<TypedDataConnection> result = new HashSet<TypedDataConnection>();
        Set ids = CollectionUtils.addAll(new HashSet(), (Object[])serviceIds);
        HashSet<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();
        for (String string : serviceIds) {
            ServiceDescriptor service = mgr.getService(string);
            if (null == service || !service.isTopLevel()) continue;
            artifacts.add(service.getArtifact());
        }
        for (ArtifactDescriptor a : artifacts) {
            for (ServiceDescriptor serviceDescriptor : a.getServices()) {
                if (!serviceDescriptor.isTopLevel() || !AbstractServiceManager.containsIdSafe(ids, serviceDescriptor.getId())) continue;
                if (ServiceKind.SOURCE_SERVICE == serviceDescriptor.getKind()) {
                    for (TypedDataConnectorDescriptor c : serviceDescriptor.getOutputDataConnectors()) {
                        result.add(new TypedDataConnection(c, null, false));
                    }
                    continue;
                }
                for (TypedDataConnectorDescriptor c : serviceDescriptor.getInputDataConnectors()) {
                    result.add(new TypedDataConnection(c, null, true));
                }
            }
        }
        return result;
    }

    public static String[] topLevel(ServiceManager mgr, String ... serviceIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : serviceIds) {
            ServiceDescriptor desc = mgr.getService(id);
            if (null == desc || !desc.isTopLevel()) continue;
            result.add(id);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] pruneServers(ServiceManager mgr, String ... serviceIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : serviceIds) {
            ServiceDescriptor desc = mgr.getService(id);
            if (null == desc) {
                desc = mgr.getService(ServiceBase.getServiceId((String)id));
            }
            if (null != desc && (null == desc || desc.getKind() == ServiceKind.SERVER)) continue;
            result.add(id);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void checkServiceInstances(String[] sId) {
        for (String id : sId) {
            if (null != this.getService(id)) continue;
            ServiceDescriptor template = null;
            String appInstanceId = ServiceBase.getApplicationInstanceId((String)id);
            String appId = ServiceBase.getApplicationId((String)id);
            String serviceId = ServiceBase.getServiceId((String)id);
            if (AbstractSetup.isNotEmpty((String)appInstanceId)) {
                template = this.getService(ServiceBase.composeId((String)serviceId, (String)appId));
            }
            if (null == template) {
                for (String tId : this.getServiceIds()) {
                    ServiceDescriptor s = this.getService(tId);
                    if (!s.getServiceId().equals(serviceId) || !((AbstractServiceDescriptor)s).getApplicationId().equals(appId)) continue;
                    template = s;
                    break;
                }
            }
            if (null == template) {
                template = this.getService(serviceId);
            }
            if (null == template) {
                LoggerFactory.getLogger(this.getClass()).warn("No service found for id {}, also no template found to instantiate.", (Object)id);
                continue;
            }
            this.instantiateFromTemplate(template, id);
            ServicesAas.notifyServiceAdded(this.getService(id));
        }
    }

    protected abstract S instantiateFromTemplate(S var1, String var2);

    public void clear() {
        this.artifacts.clear();
    }

    @Override
    public int getServiceInstanceCount(String serviceId) {
        int result = 0;
        String aId = ServiceBase.getApplicationId((String)serviceId);
        String sId = ServiceBase.getServiceId((String)serviceId);
        if (null == aId || aId.length() == 0) {
            if (null != this.getService(sId)) {
                result = 1;
            }
        } else {
            for (AbstractServiceDescriptor service : this.getServices()) {
                ServiceState state;
                String sAppId = ServiceBase.getApplicationId((String)service.getId());
                if (!aId.equals(sAppId) || !sId.equals(service.getServiceId()) || (state = service.getState()) != ServiceState.STARTING && state != ServiceState.RUNNING) continue;
                ++result;
            }
        }
        return result;
    }

    public static class TypedDataConnection
    implements TypedDataConnectorDescriptor {
        private TypedDataConnectorDescriptor connector;
        private String service;
        private boolean isInput;

        public TypedDataConnection(TypedDataConnectorDescriptor connector, String service, boolean isInput) {
            this.connector = connector;
            this.service = service;
            this.isInput = isInput;
        }

        @Override
        public String getName() {
            return this.connector.getName();
        }

        @Override
        public String getService() {
            return null == this.service ? this.connector.getService() : this.service;
        }

        @Override
        public Class<?> getType() {
            return this.connector.getType();
        }

        @Override
        public String getDescription() {
            return this.connector.getDescription();
        }

        @Override
        public String getId() {
            return this.connector.getId();
        }

        public boolean isInput() {
            return this.isInput;
        }

        public boolean isOutput() {
            return !this.isInput;
        }

        @Override
        public String getFunction() {
            return this.connector.getFunction();
        }
    }
}

