/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.environment.ServiceState;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public interface ServiceOperations {
    public static final String EXC_ALREADY_KNOWN = "is already known";
    public static final String OPTION_ENSEMBLE = "ensemble";
    public static final String OPTION_ARGS = "args";
    public static final String OPTION_SERVERS = "servers";
    public static final String OPTION_PARAMS = "params";
    public static final String OPTION_MEMLIMITS = "memLimits";

    public String addArtifact(URI var1) throws ExecutionException;

    public void startService(String ... var1) throws ExecutionException;

    public void startService(Map<String, String> var1, String ... var2) throws ExecutionException;

    public void stopService(String ... var1) throws ExecutionException;

    public void migrateService(String var1, String var2) throws ExecutionException;

    public void removeArtifact(String var1) throws ExecutionException;

    public void updateService(String var1, URI var2) throws ExecutionException;

    public void switchToService(String var1, String var2) throws ExecutionException;

    public void activateService(String var1) throws ExecutionException;

    public void passivateService(String var1) throws ExecutionException;

    public void reconfigureService(String var1, Map<String, String> var2) throws ExecutionException;

    public void setServiceState(String var1, ServiceState var2) throws ExecutionException;

    public ServiceState getServiceState(String var1);

    public int getServiceInstanceCount(String var1);

    public static StreamLogMode toMode(String value) {
        StreamLogMode result = StreamLogMode.NONE;
        if (null != value) {
            try {
                result = StreamLogMode.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    default public String streamLog(String serviceId, StreamLogMode mode) throws ExecutionException {
        return "[]";
    }

    public static enum StreamLogMode {
        START,
        TAIL,
        STOP,
        NONE;

    }
}

