/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ServerWrapper;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;
import org.junit.Assert;
import org.junit.Test;

public class ServerWrapperTest {
    @Test
    public void testWrapper() {
        TestServer server = new TestServer();
        TestWrapper wrapper = new TestWrapper(server, false);
        wrapper.start();
        TimeUtils.sleep((int)2000);
        wrapper.stop(true);
        TimeUtils.sleep((int)2000);
        Assert.assertEquals((long)1L, (long)server.startedCount);
        Assert.assertEquals((long)1L, (long)server.stoppedCount);
        server = new TestServer();
        wrapper = new TestWrapper(server, true);
        wrapper.start();
        TimeUtils.sleep((int)2000);
        wrapper.stop(true);
        TimeUtils.sleep((int)2000);
        Assert.assertEquals((long)1L, (long)server.startedCount);
        Assert.assertEquals((long)1L, (long)server.stoppedCount);
    }

    public class TestServer
    implements Server,
    Runnable {
        private boolean running;
        private int startedCount;
        private int stoppedCount;

        public Server start() {
            ++this.startedCount;
            new Thread(this).start();
            return this;
        }

        public void stop(boolean dispose) {
            ++this.stoppedCount;
            this.running = false;
            System.out.println("TestServer stopping.");
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                System.out.println("TestServer running.");
                TimeUtils.sleep((int)3000);
            }
        }
    }

    private static class TestWrapper
    extends ServerWrapper {
        private boolean requiresThread;

        public TestWrapper(Server server, boolean requiresThread) {
            super(server);
            this.requiresThread = requiresThread;
        }

        protected boolean requiresThread() {
            return super.requiresThread() || this.requiresThread;
        }
    }
}

