/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.ServicesAasClient;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.LifecycleHandler;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AbstractAasLifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.MyServiceManager;
import test.de.iip_ecosphere.platform.services.ServiceManagerTest;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class ServicesAasTest
extends TestWithQpid {
    private static Server qpid;

    @BeforeClass
    public static void startup() {
        ServicesAasTest.loadPlugins();
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        ServiceFactory.getTransport().setPort(broker.getPort());
        qpid.start();
    }

    @AfterClass
    public static void shutdown() {
        qpid.stop(true);
    }

    @Test
    public void testAas() throws IOException, ExecutionException, URISyntaxException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(ServicesAas.class));
        AasPartRegistry.AasSetup newSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup();
        System.out.println("Registry: " + newSetup.getRegistryEndpoint().toUri());
        System.out.println("Servier: " + newSetup.getServerEndpoint().toUri());
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)newSetup);
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c instanceof ServicesAas);
        ProtocolServerBuilder pBuilder = res.getProtocolServerBuilder();
        Server implServer = (Server)pBuilder.build();
        implServer.start();
        Server aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        ServicesAasClient client = new ServicesAasClient(Id.getDeviceIdAas(), "nonExApp");
        this.test(client);
        aasServer.stop(true);
        implServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    @Test
    public void testLifecycle() throws IOException, ExecutionException, URISyntaxException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        boolean oldWaitIip = AbstractAasLifecycleDescriptor.setWaitForIipAas((boolean)false);
        AasPartRegistry.AasSetup aasSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false);
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)aasSetup);
        ServiceFactory.setAasSetup((AasPartRegistry.AasSetup)aasSetup);
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Server registryServer = rcp.createRegistryServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
        AasServer aasServer = rcp.createAasServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
        LifecycleHandler.startup((String[])new String[0]);
        ServicesAasClient client = new ServicesAasClient(Id.getDeviceIdAas());
        this.test(client);
        LifecycleHandler.shutdown();
        aasServer.stop(true);
        registryServer.stop(true);
        AbstractAasLifecycleDescriptor.setWaitForIipAas((boolean)oldWaitIip);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    private void test(ServicesAasClient client) throws IOException, ExecutionException, URISyntaxException {
        ServiceManager mgr = ServiceFactory.getServiceManager();
        URI dummy = new URI("file:///dummy");
        String aId = client.addArtifact(dummy);
        Assert.assertNotNull((Object)aId);
        ArtifactDescriptor aDesc = mgr.getArtifact(aId);
        Assert.assertNotNull((Object)aId);
        Assert.assertTrue((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertTrue((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertEquals((Object)aId, (Object)aDesc.getId());
        Assert.assertTrue((aDesc.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)aDesc.getUri());
        Assert.assertTrue((aDesc.getServiceIds().size() > 0 ? 1 : 0) != 0);
        List sIds = CollectionUtils.toList(aDesc.getServiceIds().iterator());
        String sId = (String)sIds.get(0);
        Assert.assertNotNull((Object)sId);
        ServiceDescriptor sDesc = aDesc.getService(sId);
        Assert.assertNotNull((Object)sDesc);
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains(sDesc.getId()));
        Assert.assertTrue((boolean)aDesc.getServices().contains(sDesc));
        Assert.assertEquals((Object)ServiceState.AVAILABLE, (Object)client.getServiceState(sId));
        String[] ids = client.getServices(aDesc.getId(), false);
        Assert.assertEquals((long)aDesc.getServices().size(), (long)ids.length);
        boolean foundAll = true;
        for (ServiceDescriptor s : aDesc.getServices()) {
            boolean found = false;
            for (int i = 0; !found && i < ids.length; ++i) {
                found = ids[i].equals(s.getId());
            }
            foundAll &= found;
        }
        Assert.assertTrue((boolean)foundAll);
        Assert.assertNotNull((Object)client.getArtifacts());
        Assert.assertNotNull((Object)client.getRelations());
        Assert.assertNotNull((Object)client.getServices());
        Predicate av = ServicesAas.createAvailabilityPredicate((int)1000, (int)200, (boolean)false);
        Assert.assertFalse((boolean)av.test((TypedDataConnectorDescriptor)sDesc.getOutputDataConnectors().get(0)));
        client.startService(new String[]{sId});
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)client.getServiceState(sId));
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        Assert.assertEquals((long)1L, (long)client.getServiceInstanceCount(sId));
        client.passivateService(sId);
        Assert.assertEquals((Object)ServiceState.PASSIVATED, (Object)client.getServiceState(sId));
        client.activateService(sId);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)client.getServiceState(sId));
        HashMap<String, String> vals = new HashMap<String, String>();
        vals.put("here", "1.23");
        vals.put("there", "{id:15, val:12}");
        client.reconfigureService(sId, vals);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)client.getServiceState(sId));
        client.setServiceState(sId, ServiceState.RUNNING);
        Assert.assertTrue((boolean)av.test((TypedDataConnectorDescriptor)sDesc.getOutputDataConnectors().get(0)));
        client.stopService(new String[]{sId});
        Assert.assertEquals((Object)ServiceState.STOPPED, (Object)client.getServiceState(sId));
        ServiceManagerTest.assertException(() -> mgr.cloneArtifact(aId, dummy));
        ServiceManagerTest.assertException(() -> mgr.migrateService(aId, "other"));
        ServiceManagerTest.assertException(() -> mgr.switchToService(aId, sId));
        mgr.updateService(aId, dummy);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("args", JsonUtils.toJson((Object)CollectionUtils.toList((Object[])new String[]{"-Dx.y=true", "-Dy.z=false"})));
        options.put("params", "{\"service\":{\"p1\":\"v1\"}");
        client.startService(options, ids);
        this.assertOptions(mgr, options);
        client.stopService(ids);
        client.removeArtifact(aId);
        Assert.assertFalse((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertFalse((boolean)mgr.getArtifacts().contains(aDesc));
    }

    private void assertOptions(ServiceManager mgr, Map<String, String> options) {
        Assert.assertTrue((boolean)(mgr instanceof MyServiceManager));
        Map<String, String> received = ((MyServiceManager)mgr).getLastOptions();
        if (options == null) {
            Assert.assertNull(received);
        } else {
            Assert.assertEquals(options, received);
        }
    }
}

