/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ServiceFactoryDescriptor;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServiceSetup;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServiceFactory.class.getName());
    private static ServiceFactoryDescriptor desc;
    private static ServiceManager manager;
    private static ServiceSetup service;
    private static AasPartRegistry.AasSetup setup;
    private static TransportSetup transport;
    private static NetworkManagerSetup netwMgrSetup;
    private static String yamlPath;

    public static void setYamlPath(String path) {
        yamlPath = path;
    }

    private static void init() {
        if (null == desc) {
            Plugin plugin = PluginManager.getPlugin(ServiceFactoryDescriptor.class);
            if (null != plugin) {
                desc = (ServiceFactoryDescriptor)plugin.getInstance();
            }
            if (null == desc) {
                ServiceLoader loader = ServiceLoaderUtils.load(ServiceFactoryDescriptor.class);
                Optional first = ServiceLoaderUtils.findFirst((ServiceLoader)loader);
                if (first.isPresent()) {
                    desc = (ServiceFactoryDescriptor)first.get();
                } else {
                    LOGGER.warn("No Service manager implementation known.");
                }
            }
        }
    }

    public static ServiceManager getServiceManager() {
        if (null == manager) {
            ServiceFactory.init();
            if (null != desc && null != (manager = desc.createInstance())) {
                LOGGER.info("Service manager implementation registered: " + manager.getClass().getName());
            }
        }
        return manager;
    }

    public static Class<? extends ServiceSetup> getSetupClass() {
        ServiceFactory.init();
        return null == desc ? ServiceSetup.class : desc.getSetupClass();
    }

    public static ServiceSetup getSetup() {
        return ServiceFactory.getFromSetup(service, d -> d.getSetup(), s -> s, () -> new ServiceSetup(), t -> {
            service = t;
        });
    }

    public static AasPartRegistry.AasSetup getAasSetup() {
        return ServiceFactory.getFromSetup(setup, d -> d.getAasSetup(), s -> s.getAas(), () -> new AasPartRegistry.AasSetup(), t -> {
            setup = t;
        });
    }

    public static NetworkManagerSetup getNetworkManagerSetup() {
        return ServiceFactory.getFromSetup(netwMgrSetup, d -> null, s -> s.getNetMgr(), () -> new NetworkManagerSetup(), t -> {
            netwMgrSetup = t;
        });
    }

    public static TransportSetup getTransport() {
        return ServiceFactory.getFromSetup(transport, d -> d.getTransport(), s -> s.getTransport(), () -> new TransportSetup(), t -> {
            transport = t;
        });
    }

    private static <T> T getFromSetup(T object, Function<ServiceFactoryDescriptor, T> fromDesc, Function<ServiceSetup, T> fromSetup, Supplier<T> constructor, Consumer<T> setter) {
        T result = object;
        if (null == result) {
            ServiceFactory.init();
            if (null != desc) {
                result = fromDesc.apply(desc);
            }
            if (null == result) {
                try {
                    ServiceSetup cfg = (ServiceSetup)AbstractSetup.readFromYamlWithPath(ServiceFactory.getSetupClass(), (String)yamlPath);
                    result = fromSetup.apply(cfg);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(ServiceFactory.class).warn("Cannot read setup: " + e.getMessage());
                }
                if (null == result) {
                    result = constructor.get();
                }
            }
            setter.accept(result);
        }
        return result;
    }

    public static void setAasSetup(AasPartRegistry.AasSetup instance) {
        setup = instance;
    }

    public static void setNetworkManagerSetup(NetworkManagerSetup instance) {
        netwMgrSetup = instance;
    }

    public static Class<?>[] getTests(int index) {
        Class<?>[] result = null;
        ServiceFactory.init();
        if (null != desc) {
            result = desc.getTests(index);
        }
        return result;
    }

    static {
        manager = null;
    }
}

