/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml.api.parts;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasDataSpecificationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.IdentifiableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssetXMLConverter {
    public static final String ASSETS = "aas:assets";
    public static final String ASSET = "aas:asset";
    public static final String ASSET_IDENTIFICATION_MODEL_REF = "aas:assetIdentificationModelRef";
    public static final String ASSET_KIND = "aas:kind";
    public static final String ASSET_BILLOFMATERIAL = "aas:billOfMaterialRef";

    public static List<IAsset> parseAssets(Map<String, Object> xmlAssetObject) {
        List<Map<String, Object>> xmlAssets = XMLHelper.getList(xmlAssetObject.get(ASSET));
        ArrayList<IAsset> assets = new ArrayList<IAsset>();
        for (Map<String, Object> xmlAsset : xmlAssets) {
            Asset asset = new Asset();
            IdentifiableXMLConverter.populateIdentifiable(xmlAsset, Identifiable.createAsFacadeNonStrict(asset, KeyElements.ASSET));
            HasDataSpecificationXMLConverter.populateHasDataSpecification(xmlAsset, HasDataSpecification.createAsFacade(asset));
            asset.setAssetKind(AssetXMLConverter.parseAssetKind(xmlAsset));
            if (xmlAsset.containsKey(ASSET_IDENTIFICATION_MODEL_REF)) {
                asset.setAssetIdentificationModel(AssetXMLConverter.parseAssetIdentificationModelRef(xmlAsset));
            }
            assets.add(asset);
        }
        return assets;
    }

    private static IReference parseAssetIdentificationModelRef(Map<String, Object> xmlObject) {
        Map semanticIDObj = (Map)xmlObject.get(ASSET_IDENTIFICATION_MODEL_REF);
        return ReferenceXMLConverter.parseReference(semanticIDObj);
    }

    private static AssetKind parseAssetKind(Map<String, Object> xmlObject) {
        String assetKindValue = XMLHelper.getString(xmlObject.get(ASSET_KIND));
        if (!Strings.isNullOrEmpty((String)assetKindValue)) {
            return AssetKind.fromString(assetKindValue);
        }
        throw new RuntimeException("Necessary value 'AssetKind' was not found for one of the Assets in the XML file.");
    }

    public static Element buildAssetsXML(Document document, Collection<IAsset> assets) {
        Element root = document.createElement(ASSETS);
        ArrayList<Element> xmlAssetList = new ArrayList<Element>();
        for (IAsset asset : assets) {
            Element assetRoot = document.createElement(ASSET);
            IdentifiableXMLConverter.populateIdentifiableXML(document, assetRoot, asset);
            HasDataSpecificationXMLConverter.populateHasDataSpecificationXML(document, assetRoot, asset);
            AssetXMLConverter.buildAssetIdentificationModelRef(document, assetRoot, asset);
            AssetXMLConverter.buildBillOfMaterial(document, assetRoot, asset);
            AssetXMLConverter.buildAssetKind(document, assetRoot, asset);
            xmlAssetList.add(assetRoot);
        }
        for (Element element : xmlAssetList) {
            root.appendChild(element);
        }
        return root;
    }

    private static void buildAssetIdentificationModelRef(Document document, Element assetRoot, IAsset asset) {
        IReference assetIdentificationModel = asset.getAssetIdentificationModel();
        if (assetIdentificationModel != null) {
            Element assetIdentificationroot = document.createElement(ASSET_IDENTIFICATION_MODEL_REF);
            assetIdentificationroot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, assetIdentificationModel));
            assetRoot.appendChild(assetIdentificationroot);
        }
    }

    private static void buildAssetKind(Document document, Element root, IAsset asset) {
        if (asset.getAssetKind() != null) {
            Element kindRoot = document.createElement(ASSET_KIND);
            kindRoot.appendChild(document.createTextNode(asset.getAssetKind().toString()));
            root.appendChild(kindRoot);
        }
    }

    private static void buildBillOfMaterial(Document document, Element root, IAsset asset) {
        IReference billOfMaterial = asset.getBillOfMaterial();
        if (billOfMaterial != null) {
            Element billOfMaterialRoot = document.createElement(ASSET_BILLOFMATERIAL);
            billOfMaterialRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, billOfMaterial));
            root.appendChild(billOfMaterialRoot);
        }
    }
}

