/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.descriptor;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IHasSemantics;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;

public class SubmodelDescriptor
extends ModelDescriptor
implements IHasSemantics {
    public static final String MODELTYPE = "SubmodelDescriptor";

    public SubmodelDescriptor(Map<String, Object> map) {
        super(map);
        this.validate(map);
    }

    public SubmodelDescriptor(ISubmodel sm, String httpEndpoint) {
        this(sm.getIdShort(), sm.getIdentification(), httpEndpoint);
        this.putAll(new HasSemantics(sm.getSemanticId()));
    }

    public SubmodelDescriptor(String idShort, IIdentifier id, String httpEndpoint) {
        super(idShort, id, SubmodelDescriptor.harmonizeEndpoint(httpEndpoint));
        this.putAll(new ModelType(MODELTYPE));
    }

    @Override
    protected String getModelType() {
        return MODELTYPE;
    }

    private static String harmonizeEndpoint(String endpoint) {
        if (!endpoint.endsWith("/submodel")) {
            return endpoint + "/submodel";
        }
        return endpoint;
    }

    @Override
    public IReference getSemanticId() {
        return HasSemantics.createAsFacade(this).getSemanticId();
    }

    public void setSemanticId(Reference ref) {
        HasSemantics.createAsFacade(this).setSemanticId(ref);
    }
}

