/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IBlob;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedDataElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;

public class ConnectedBlob
extends ConnectedDataElement
implements IBlob {
    public ConnectedBlob(VABElementProxy proxy) {
        super(proxy);
    }

    @Override
    public String getValue() {
        Object connectedValue = this.getProxy().getValue("value");
        if (connectedValue instanceof String) {
            return (String)connectedValue;
        }
        return null;
    }

    @Override
    public String getMimeType() {
        return (String)this.getElem().get("mimeType");
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.BLOB;
    }

    @Override
    public Blob getLocalCopy() {
        return Blob.createAsFacade(this.getElem()).getLocalCopy();
    }

    @Override
    public void setValue(String value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Given Object is not a String");
        }
        this.setValue((Object)value);
    }

    @Override
    public byte[] getByteArrayValue() {
        String value = this.getValue();
        if (value != null) {
            return Base64.getDecoder().decode(value);
        }
        return null;
    }

    @Override
    public void setByteArrayValue(byte[] value) {
        this.setValue((Object)Base64.getEncoder().encodeToString(value));
    }

    @Override
    public String getUTF8String() {
        return this.getLocalCopy().getUTF8String();
    }

    @Override
    public void setUTF8String(String text) {
        byte[] byteArray = text.getBytes(StandardCharsets.UTF_8);
        this.setByteArrayValue(byteArray);
    }
}

