/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.facade;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;

public class SubmodelElementMapCollectionConverter {
    public static Submodel mapToSM(Map<String, Object> submodel) {
        Submodel ret = new Submodel();
        ret.setMap(submodel);
        Object smElements = submodel.get("submodelElements");
        ret.put("submodelElements", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(smElements));
        return ret;
    }

    public static Map<String, Object> smToMap(Submodel submodel) {
        Map<String, ISubmodelElement> smElements = submodel.getSubmodelElements();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.putAll(submodel);
        List newElements = smElements.values().stream().map(e -> SubmodelElementMapCollectionConverter.smElementToMap((Map)((Object)e))).collect(Collectors.toList());
        ret.put("submodelElements", newElements);
        return ret;
    }

    public static SubmodelElementCollection mapToSmECollection(Map<String, Object> smECollection) {
        SubmodelElementCollection ret = new SubmodelElementCollection();
        ret.setMap(smECollection);
        Object smElements = smECollection.get("value");
        ret.put("value", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(smElements));
        return ret;
    }

    public static Map<String, Object> smElementToMap(Map<String, Object> smElement) {
        if (!SubmodelElementCollection.isSubmodelElementCollection(smElement)) {
            return smElement;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.putAll(smElement);
        ret.put("value", SubmodelElementMapCollectionConverter.convertIDMapToCollection(smElement.get("value")));
        return ret;
    }

    public static Map<String, Object> convertCollectionToIDMap(Object smElements) {
        Map<String, Object> smElementsMap = new HashMap<String, Object>();
        if (smElements == null) {
            return smElementsMap;
        }
        if (smElements instanceof Collection) {
            Collection smElementsSet = (Collection)smElements;
            for (Object o : smElementsSet) {
                Map smElement2 = (Map)o;
                String id2 = (String)smElement2.get("idShort");
                smElementsMap.put(id2, smElement2);
            }
        } else if (smElements instanceof Map) {
            smElementsMap = (Map)smElements;
        } else {
            throw new RuntimeException("Elements must be given as Map or Collection");
        }
        smElementsMap.replaceAll((id, smElement) -> SubmodelElementFacadeFactory.createSubmodelElement((Map)smElement));
        return smElementsMap;
    }

    public static Collection<Map<String, Object>> convertIDMapToCollection(Object map) {
        Collection smElements = null;
        if (map instanceof Collection) {
            smElements = (Collection)map;
        } else if (map instanceof Map) {
            smElements = ((Map)map).values();
        } else {
            throw new RuntimeException("The SubmodelElementCollection contains neither a Collection nor a Map as value.");
        }
        List<Map<String, Object>> newElements = smElements.stream().map(e -> SubmodelElementMapCollectionConverter.smElementToMap((Map)e)).collect(Collectors.toList());
        return newElements;
    }
}

