/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IBlob;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;

public class Blob
extends DataElement
implements IBlob {
    public static final String MIMETYPE = "mimeType";
    public static final String MODELTYPE = "Blob";

    public Blob() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public Blob(String idShort, String mimeType) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.setMimeType(mimeType);
    }

    public Blob(byte[] value, String mimeType) {
        this.putAll(new ModelType(MODELTYPE));
        this.setByteArrayValue(value);
        this.setMimeType(mimeType);
    }

    public static Blob createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Blob.isValid(obj)) {
            throw new MetamodelConstructionException(Blob.class, obj);
        }
        Blob facade = new Blob();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return DataElement.isValid(obj) && obj.containsKey(MIMETYPE);
    }

    public static boolean isBlob(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey("value") && map.containsKey(MIMETYPE);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Given Object is not a String");
        }
        this.setValue((String)value);
    }

    @Override
    public String getValue() {
        if (!this.containsKey("value")) {
            return null;
        }
        return (String)this.get("value");
    }

    @Override
    public byte[] getByteArrayValue() {
        String value = this.getValue();
        if (value != null) {
            return Base64.getDecoder().decode(value);
        }
        return null;
    }

    @Override
    public String getUTF8String() {
        byte[] value = this.getByteArrayValue();
        return new String(value, StandardCharsets.UTF_8);
    }

    @Override
    public void setUTF8String(String text) {
        this.setByteArrayValue(text.getBytes(StandardCharsets.UTF_8));
    }

    public void setMimeType(String mimeType) {
        this.put(MIMETYPE, mimeType);
    }

    @Override
    public String getMimeType() {
        return (String)this.get(MIMETYPE);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.BLOB;
    }

    @Override
    public Blob getLocalCopy() {
        Blob copy = new Blob();
        copy.putAll(this);
        return copy;
    }

    @Override
    public void setByteArrayValue(byte[] value) {
        if (value != null) {
            this.setValue(Base64.getEncoder().encodeToString(value));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public void setValue(String value) {
        this.put("value", value);
    }
}

