/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate;

import java.util.Collections;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address.Address;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.assetspecificproperties.AssetSpecificProperties;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.markings.Markings;

public class DigitalNameplateSubmodel
extends Submodel {
    public static final String MANUFACTURERNAMEID = "ManufacturerName";
    public static final String MANUFACTURERPRODUCTDESIGNATIONID = "ManufacturerProductDesignation";
    public static final String ADDRESSID = "Address";
    public static final String MANUFACTURERPRODUCTFAMILYID = "ManufacturerProductFamily";
    public static final String SERIALNUMBERID = "SerialNumber";
    public static final String YEARSOFCONSTRUCTIONID = "YearOfConstruction";
    public static final String MARKINGSID = "Markings";
    public static final String ASSETSPECIFICPROPERTIESID = "AssetSpecificProperties";
    public static final Reference SEMANTICID = new Reference(Collections.singletonList(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/zvei/nameplate/1/0/Nameplate", KeyType.IRI)));
    public static final String SUBMODELID = "Nameplate";

    private DigitalNameplateSubmodel() {
    }

    public DigitalNameplateSubmodel(Identifier identifier, MultiLanguageProperty manufacturerName, MultiLanguageProperty manufacturerProductDesignation, Address address, MultiLanguageProperty manufacturerProductFamily, Property yearsOfConstruction) {
        this(SUBMODELID, identifier, manufacturerName, manufacturerProductDesignation, address, manufacturerProductFamily, yearsOfConstruction);
    }

    public DigitalNameplateSubmodel(Identifier identifier, LangString manufacturerName, LangString manufacturerProductDesignation, Address address, LangString manufacturerProductFamily, String yearsOfConstruction) {
        this(SUBMODELID, identifier, manufacturerName, manufacturerProductDesignation, address, manufacturerProductFamily, yearsOfConstruction);
    }

    public DigitalNameplateSubmodel(String idShort, Identifier identifier, MultiLanguageProperty manufacturerName, MultiLanguageProperty manufacturerProductDesignation, Address address, MultiLanguageProperty manufacturerProductFamily, Property yearsOfConstruction) {
        super(idShort, identifier);
        this.setSemanticId(SEMANTICID);
        this.setManufacturerName(manufacturerName);
        this.setManufacturerProductDesignation(manufacturerProductDesignation);
        this.setAddress(address);
        this.setManufacturerProductFamily(manufacturerProductFamily);
        this.setYearOfConstruction(yearsOfConstruction);
    }

    public DigitalNameplateSubmodel(String idShort, Identifier identifier, LangString manufacturerName, LangString manufacturerProductDesignation, Address address, LangString manufacturerProductFamily, String yearsOfConstruction) {
        super(idShort, identifier);
        this.setSemanticId(SEMANTICID);
        this.setManufacturerName(manufacturerName);
        this.setManufacturerProductDesignation(manufacturerProductDesignation);
        this.setAddress(address);
        this.setManufacturerProductFamily(manufacturerProductFamily);
        this.setYearOfConstruction(yearsOfConstruction);
    }

    public static DigitalNameplateSubmodel createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!DigitalNameplateSubmodel.isValid(obj)) {
            throw new MetamodelConstructionException(DigitalNameplateSubmodel.class, obj);
        }
        DigitalNameplateSubmodel ret = new DigitalNameplateSubmodel();
        ret.setMap(SubmodelElementMapCollectionConverter.mapToSM(obj));
        return ret;
    }

    private static DigitalNameplateSubmodel createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        DigitalNameplateSubmodel ret = new DigitalNameplateSubmodel();
        ret.setMap(SubmodelElementMapCollectionConverter.mapToSM(obj));
        return ret;
    }

    public static boolean isValid(Map<String, Object> obj) {
        DigitalNameplateSubmodel submodel = DigitalNameplateSubmodel.createAsFacadeNonStrict(obj);
        return Submodel.isValid(obj) && MultiLanguageProperty.isValid((Map)((Object)submodel.getManufacturerName())) && MultiLanguageProperty.isValid((Map)((Object)submodel.getManufacturerProductDesignation())) && Address.isValid(submodel.getAddress()) && MultiLanguageProperty.isValid((Map)((Object)submodel.getManufacturerProductFamily())) && Property.isValid((Map)((Object)submodel.getYearOfConstruction()));
    }

    public void setManufacturerName(MultiLanguageProperty manufacturerName) {
        this.addSubmodelElement(manufacturerName);
    }

    public void setManufacturerName(LangString manufacturerName) {
        MultiLanguageProperty manufacturerNameProp = new MultiLanguageProperty(MANUFACTURERNAMEID);
        manufacturerNameProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO677#002", IdentifierType.IRDI)));
        manufacturerNameProp.setValue(new LangStrings(manufacturerName));
        this.setManufacturerName(manufacturerNameProp);
    }

    public IMultiLanguageProperty getManufacturerName() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERNAMEID)));
    }

    public void setManufacturerProductDesignation(MultiLanguageProperty manufacturerProductDesignation) {
        this.addSubmodelElement(manufacturerProductDesignation);
    }

    public void setManufacturerProductDesignation(LangString manufacturerProductDesignation) {
        MultiLanguageProperty manufacturerProductDesignationProp = new MultiLanguageProperty(MANUFACTURERPRODUCTDESIGNATIONID);
        manufacturerProductDesignationProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAW338#001", IdentifierType.IRDI)));
        manufacturerProductDesignationProp.setValue(new LangStrings(manufacturerProductDesignation));
        this.setManufacturerProductDesignation(manufacturerProductDesignationProp);
    }

    public IMultiLanguageProperty getManufacturerProductDesignation() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERPRODUCTDESIGNATIONID)));
    }

    public void setAddress(Address address) {
        this.addSubmodelElement(address);
    }

    public Address getAddress() {
        ISubmodelElement element = this.getSubmodelElement(ADDRESSID);
        return element == null ? null : Address.createAsFacade((Map)((Object)element));
    }

    public void setManufacturerProductFamily(MultiLanguageProperty manufacturerProductFamily) {
        this.addSubmodelElement(manufacturerProductFamily);
    }

    public void setManufacturerProductFamily(LangString manufacturerProductFamily) {
        MultiLanguageProperty manufacturerProductFamilyProp = new MultiLanguageProperty(MANUFACTURERPRODUCTFAMILYID);
        manufacturerProductFamilyProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAU731#001", IdentifierType.IRDI)));
        manufacturerProductFamilyProp.setValue(new LangStrings(manufacturerProductFamily));
        this.setManufacturerProductFamily(manufacturerProductFamilyProp);
    }

    public IMultiLanguageProperty getManufacturerProductFamily() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERPRODUCTFAMILYID)));
    }

    public void setSerialNumber(Property serialNumber) {
        this.addSubmodelElement(serialNumber);
    }

    public void setSerialNumber(String serialNumber) {
        Property serialNumberProp = new Property(SERIALNUMBERID, ValueType.String);
        serialNumberProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAM556#002", IdentifierType.IRDI)));
        serialNumberProp.setValue(serialNumber);
        this.setSerialNumber(serialNumberProp);
    }

    public IProperty getSerialNumber() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(SERIALNUMBERID)));
    }

    public void setYearOfConstruction(Property yearsOfConstruction) {
        this.addSubmodelElement(yearsOfConstruction);
    }

    public void setYearOfConstruction(String yearsOfConstruction) {
        Property yearsOfConstructionProp = new Property(YEARSOFCONSTRUCTIONID, ValueType.String);
        yearsOfConstructionProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAP906#001", IdentifierType.IRDI)));
        yearsOfConstructionProp.setValue(yearsOfConstruction);
        this.setYearOfConstruction(yearsOfConstructionProp);
    }

    public IProperty getYearOfConstruction() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(YEARSOFCONSTRUCTIONID)));
    }

    public void setMarkings(Markings markings) {
        this.addSubmodelElement(markings);
    }

    public Markings getMarkings() {
        ISubmodelElement element = this.getSubmodelElement(MARKINGSID);
        return element == null ? null : Markings.createAsFacade((Map)((Object)element));
    }

    public void setAssetSpecificProperties(AssetSpecificProperties assetSpecificProperties) {
        this.addSubmodelElement(assetSpecificProperties);
    }

    public AssetSpecificProperties getAssetSpecificProperties() {
        ISubmodelElement element = this.getSubmodelElement(ASSETSPECIFICPROPERTIESID);
        return element == null ? null : AssetSpecificProperties.createAsFacade((Map)((Object)element));
    }
}

