/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;

public abstract class VabInvocablesCreator
implements InvocablesCreator,
Serializable {
    private static final long serialVersionUID = -4388430468665656598L;

    protected abstract VABElementProxy createProxy();

    protected abstract String getId();

    public Invokable createGetter(String name) {
        return new Getter(this, name);
    }

    public Invokable createSetter(String name) {
        return new Setter(this, name);
    }

    public Invokable createInvocable(String name) {
        return new Operation(this, name);
    }

    protected static class Getter
    extends AbstractFunctor
    implements Invokable.GetterInvokable {
        private static final long serialVersionUID = -9126944118648742265L;

        protected Getter(VabInvocablesCreator creator, String name) {
            super(creator, name);
        }

        public Object get() {
            Object result = null;
            try {
                if (this.isOk()) {
                    result = this.createProxy().getValue("status/" + this.getName());
                }
            }
            catch (Throwable t) {
                this.markAsFailed();
                LoggerFactory.getLogger(this.getClass()).info("Getter " + this.getName() + " on " + this.getId() + " failed: " + t.getMessage());
            }
            return result;
        }
    }

    protected static class Setter
    extends AbstractFunctor
    implements Invokable.SetterInvokable {
        private static final long serialVersionUID = 2420859918496174956L;

        protected Setter(VabInvocablesCreator creator, String name) {
            super(creator, name);
        }

        public void accept(Object value) {
            try {
                if (this.isOk()) {
                    this.createProxy().setValue("status/" + this.getName(), value);
                }
            }
            catch (Throwable t) {
                this.markAsFailed();
                LoggerFactory.getLogger(this.getClass()).info("Setter " + this.getName() + " on " + this.getId() + " failed: " + t.getMessage());
            }
        }
    }

    protected static class Operation
    extends AbstractFunctor
    implements Invokable.OperationInvokable {
        private static final long serialVersionUID = -3021593348876711589L;

        protected Operation(VabInvocablesCreator creator, String name) {
            super(creator, name);
        }

        public Object apply(Object[] params) {
            Object result = null;
            try {
                if (!this.isOk()) {
                    throw new RuntimeException("Connection failed before and was blocked until timeout of 60000 ms");
                }
                result = this.createProxy().invokeOperation("operations/service/" + this.getName(), params);
            }
            catch (Throwable t) {
                this.markAsFailed();
                LoggerFactory.getLogger(this.getClass()).info("Operation " + this.getName() + " on " + this.getId() + " failed: " + t.getMessage());
                throw t;
            }
            return result;
        }
    }

    protected static abstract class AbstractFunctor
    implements Serializable {
        protected static final long TIMEOUT = 60000L;
        private static final long serialVersionUID = 4104858388150273917L;
        private static Map<String, Long> failed;
        private VabInvocablesCreator creator;
        private String name;

        protected AbstractFunctor(VabInvocablesCreator creator, String name) {
            this.creator = creator;
            this.name = name;
        }

        protected void markAsFailed() {
            if (null == failed) {
                failed = new HashMap<String, Long>();
            }
            failed.put(this.creator.getId(), System.currentTimeMillis());
        }

        protected boolean isOk() {
            String id;
            Long time;
            boolean ok = true;
            if (null != failed && null != (time = failed.get(id = this.creator.getId()))) {
                if (System.currentTimeMillis() - time >= 60000L) {
                    failed.remove(id);
                } else {
                    ok = false;
                }
            }
            return ok;
        }

        protected VabInvocablesCreator getCreator() {
            return this.creator;
        }

        protected VABElementProxy createProxy() {
            return this.creator.createProxy();
        }

        protected String getId() {
            return this.creator.getId();
        }

        public String getName() {
            return this.name;
        }
    }
}

