/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.models.controlcomponent;

import org.eclipse.basyx.models.controlcomponent.ControlComponent;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;

public class SimpleControlComponent
extends ControlComponent {
    private static final long serialVersionUID = 1L;
    private boolean explicitResetFinished;

    public SimpleControlComponent() {
        this(false);
    }

    public SimpleControlComponent(boolean explicitResetFinished) {
        this.explicitResetFinished = explicitResetFinished;
        this.setExecutionState("idle");
    }

    @Override
    protected String filterExecutionState(String newExecutionState) {
        switch (newExecutionState.toLowerCase()) {
            case "starting": {
                return ExecutionState.EXECUTE.getValue();
            }
            case "completing": {
                return ExecutionState.COMPLETE.getValue();
            }
            case "resetting": {
                if (this.explicitResetFinished) break;
                return ExecutionState.IDLE.getValue();
            }
            case "aborting": {
                return ExecutionState.ABORTED.getValue();
            }
            case "clearing": {
                return ExecutionState.STOPPED.getValue();
            }
        }
        return newExecutionState;
    }
}

