/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.memory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class MapRegistryHandler
implements IRegistryHandler {
    protected Map<String, AASDescriptor> descriptorMap;

    public MapRegistryHandler(Map<String, AASDescriptor> rootMap) {
        this.descriptorMap = rootMap;
    }

    @Override
    public boolean contains(IIdentifier id) {
        return this.descriptorMap.containsKey(id.getId());
    }

    @Override
    public void remove(IIdentifier id) {
        AASDescriptor removed = this.descriptorMap.remove(id.getId());
        IIdentifier aasId = removed.getIdentifier();
        if (!aasId.getId().equals(id.getId())) {
            this.descriptorMap.remove(aasId.getId());
        } else {
            IAsset asset = removed.getAsset();
            if (asset != null) {
                IIdentifier assetId = asset.getIdentification();
                this.descriptorMap.remove(assetId.getId());
            }
        }
    }

    @Override
    public void insert(AASDescriptor descriptor) {
        String id = descriptor.getIdentifier().getId();
        this.descriptorMap.put(id, descriptor);
        IAsset asset = descriptor.getAsset();
        if (asset != null) {
            String assetId = asset.getIdentification().getId();
            this.descriptorMap.put(assetId, descriptor);
        }
    }

    @Override
    public void update(AASDescriptor descriptor) {
        this.insert(descriptor);
    }

    @Override
    public AASDescriptor get(IIdentifier id) {
        return this.descriptorMap.get(id.getId());
    }

    @Override
    public List<AASDescriptor> getAll() {
        return new ArrayList<AASDescriptor>(new HashSet<AASDescriptor>(this.descriptorMap.values()));
    }
}

