/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class TaggedAASDescriptor
extends AASDescriptor {
    public static final String MODELTYPE = "TaggedAASDescriptor";
    public static final String TAGS = "tags";

    public TaggedAASDescriptor(IAssetAdministrationShell assetAdministrationShell, String endpoint) {
        super(assetAdministrationShell, endpoint);
        this.initialize();
    }

    protected TaggedAASDescriptor() {
    }

    public static TaggedAASDescriptor createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Collection tags = (Collection)map.get(TAGS);
        if (tags instanceof List) {
            map.put(TAGS, new HashSet(tags));
        }
        TaggedAASDescriptor desc = new TaggedAASDescriptor();
        desc.putAll(map);
        return desc;
    }

    public TaggedAASDescriptor(String idShort, IIdentifier id, String httpEndpoint) {
        super(idShort, id, httpEndpoint);
        this.initialize();
    }

    private void initialize() {
        this.put(TAGS, new HashSet());
    }

    public void addTag(String tag) {
        this.getTags().add(tag);
    }

    public void addTags(List<String> tags) {
        tags.stream().forEach(this::addTag);
    }

    public Set<String> getTags() {
        return (Set)this.get(TAGS);
    }

    @Override
    protected String getModelType() {
        return MODELTYPE;
    }
}

