/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasDataSpecificationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasSemanticsXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.ReferableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.haskind.HasKindXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.qualifiable.QualifiableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.CapabilityXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementCollectionXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.BlobXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.FileXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.MultiLanguagePropertyXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.PropertyXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.RangeXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement.ReferenceElementXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.entity.EntityXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.event.BasicEventXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.operation.OperationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.relationship.AnnotatedRelationshipElementXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.relationship.RelationshipElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ICapability;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IBlob;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IRange;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IReferenceElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.entity.IEntity;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.event.IBasicEvent;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IAnnotatedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.haskind.HasKind;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifiable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubmodelElementXMLConverter {
    public static final String SUBMODEL_ELEMENTS = "aas:submodelElements";
    public static final String SUBMODEL_ELEMENT = "aas:submodelElement";
    public static final String DATA_ELEMENT = "aas:dataElement";
    public static final String VALUE = "aas:value";
    public static final String VALUE_TYPE = "aas:valueType";
    public static final String VALUE_ID = "aas:valueId";
    public static final String MIME_TYPE = "aas:mimeType";

    public static List<ISubmodelElement> parseSubmodelElements(Map<String, Object> xmlSubmodelElements) {
        Map xmlSubmodelElementsMap = (Map)xmlSubmodelElements.get(SUBMODEL_ELEMENTS);
        return SubmodelElementXMLConverter.getSubmodelElements(xmlSubmodelElementsMap);
    }

    protected static List<ISubmodelElement> getSubmodelElements(Map<String, Object> xmlObject) {
        ArrayList<ISubmodelElement> submodelElemList = new ArrayList<ISubmodelElement>();
        if (xmlObject == null) {
            return submodelElemList;
        }
        List<Map<String, Object>> xmlSubmodelElemList = XMLHelper.getList(xmlObject.get(SUBMODEL_ELEMENT));
        for (Map<String, Object> xmlSubmodelElem : xmlSubmodelElemList) {
            submodelElemList.add(SubmodelElementXMLConverter.getSubmodelElement(xmlSubmodelElem));
        }
        return submodelElemList;
    }

    public static SubmodelElement getSubmodelElement(Map<String, Object> xmlObject) {
        if (xmlObject.containsKey("aas:property")) {
            xmlObject = (Map)xmlObject.get("aas:property");
            return PropertyXMLConverter.parseProperty(xmlObject);
        }
        if (xmlObject.containsKey("aas:basicEvent")) {
            xmlObject = (Map)xmlObject.get("aas:basicEvent");
            return BasicEventXMLConverter.parseBasicEvent(xmlObject);
        }
        if (xmlObject.containsKey("aas:capability")) {
            xmlObject = (Map)xmlObject.get("aas:capability");
            return CapabilityXMLConverter.parseCapability(xmlObject);
        }
        if (xmlObject.containsKey("aas:entity")) {
            xmlObject = (Map)xmlObject.get("aas:entity");
            return EntityXMLConverter.parseEntity(xmlObject);
        }
        if (xmlObject.containsKey("aas:multiLanguageProperty")) {
            xmlObject = (Map)xmlObject.get("aas:multiLanguageProperty");
            return MultiLanguagePropertyXMLConverter.parseMultiLanguageProperty(xmlObject);
        }
        if (xmlObject.containsKey("aas:range")) {
            xmlObject = (Map)xmlObject.get("aas:range");
            return RangeXMLConverter.parseRange(xmlObject);
        }
        if (xmlObject.containsKey("aas:file")) {
            xmlObject = (Map)xmlObject.get("aas:file");
            return FileXMLConverter.parseFile(xmlObject);
        }
        if (xmlObject.containsKey("aas:blob")) {
            xmlObject = (Map)xmlObject.get("aas:blob");
            return BlobXMLConverter.parseBlob(xmlObject);
        }
        if (xmlObject.containsKey("aas:referenceElement")) {
            xmlObject = (Map)xmlObject.get("aas:referenceElement");
            return ReferenceElementXMLConverter.parseReferenceElement(xmlObject);
        }
        if (xmlObject.containsKey("aas:submodelElementCollection")) {
            xmlObject = (Map)xmlObject.get("aas:submodelElementCollection");
            return SubmodelElementCollectionXMLConverter.parseSubmodelElementCollection(xmlObject);
        }
        if (xmlObject.containsKey("aas:relationshipElement")) {
            xmlObject = (Map)xmlObject.get("aas:relationshipElement");
            return RelationshipElementXMLConverter.parseRelationshipElement(xmlObject);
        }
        if (xmlObject.containsKey("aas:annotatedRelationshipElement")) {
            xmlObject = (Map)xmlObject.get("aas:annotatedRelationshipElement");
            return AnnotatedRelationshipElementXMLConverter.parseAnnotatedRelationshipElement(xmlObject);
        }
        if (xmlObject.containsKey("aas:operation")) {
            xmlObject = (Map)xmlObject.get("aas:operation");
            return OperationXMLConverter.parseOperation(xmlObject);
        }
        return null;
    }

    protected static void populateSubmodelElement(Map<String, Object> xmlObject, ISubmodelElement submodelElement) {
        ReferableXMLConverter.populateReferable(xmlObject, Referable.createAsFacadeNonStrict((Map)((Object)submodelElement), KeyElements.SUBMODELELEMENT));
        QualifiableXMLConverter.populateQualifiable(xmlObject, Qualifiable.createAsFacade((Map)((Object)submodelElement)));
        HasDataSpecificationXMLConverter.populateHasDataSpecification(xmlObject, HasDataSpecification.createAsFacade((Map)((Object)submodelElement)));
        HasSemanticsXMLConverter.populateHasSemantics(xmlObject, HasSemantics.createAsFacade((Map)((Object)submodelElement)));
        HasKindXMLConverter.populateHasKind(xmlObject, HasKind.createAsFacade((Map)((Object)submodelElement)));
    }

    public static Element buildSubmodelElementsXML(Document document, Collection<ISubmodelElement> submodelElements) {
        Element xmlSubmodelElements = document.createElement(SUBMODEL_ELEMENTS);
        SubmodelElementXMLConverter.buildSubmodelElements(document, xmlSubmodelElements, submodelElements);
        return xmlSubmodelElements;
    }

    protected static void buildSubmodelElements(Document document, Element root, Collection<ISubmodelElement> submodelElements) {
        for (ISubmodelElement submodelElement : submodelElements) {
            Element xmlSubmodelElement = document.createElement(SUBMODEL_ELEMENT);
            Element elem = SubmodelElementXMLConverter.buildSubmodelElement(document, submodelElement);
            xmlSubmodelElement.appendChild(elem);
            root.appendChild(xmlSubmodelElement);
        }
    }

    public static Element buildSubmodelElement(Document document, ISubmodelElement submodelElement) {
        String type;
        switch (type = submodelElement.getModelType()) {
            case "Property": {
                return PropertyXMLConverter.buildProperty(document, (IProperty)submodelElement);
            }
            case "BasicEvent": {
                return BasicEventXMLConverter.buildBasicEvent(document, (IBasicEvent)submodelElement);
            }
            case "MultiLanguageProperty": {
                return MultiLanguagePropertyXMLConverter.buildMultiLanguageProperty(document, (IMultiLanguageProperty)submodelElement);
            }
            case "Range": {
                return RangeXMLConverter.buildRange(document, (IRange)submodelElement);
            }
            case "Entity": {
                return EntityXMLConverter.buildEntity(document, (IEntity)submodelElement);
            }
            case "File": {
                return FileXMLConverter.buildFile(document, (IFile)submodelElement);
            }
            case "Blob": {
                return BlobXMLConverter.buildBlob(document, (IBlob)submodelElement);
            }
            case "ReferenceElement": {
                return ReferenceElementXMLConverter.buildReferenceElement(document, (IReferenceElement)submodelElement);
            }
            case "SubmodelElementCollection": {
                return SubmodelElementCollectionXMLConverter.buildSubmodelElementCollection(document, (ISubmodelElementCollection)submodelElement);
            }
            case "RelationshipElement": {
                return RelationshipElementXMLConverter.buildRelationshipElement(document, (IRelationshipElement)submodelElement);
            }
            case "AnnotatedRelationshipElement": {
                return AnnotatedRelationshipElementXMLConverter.buildAnnotatedRelationshipElement(document, (IAnnotatedRelationshipElement)submodelElement);
            }
            case "Operation": {
                return OperationXMLConverter.buildOperation(document, (IOperation)submodelElement);
            }
            case "Capability": {
                return CapabilityXMLConverter.buildCapability(document, (ICapability)submodelElement);
            }
        }
        return null;
    }

    protected static void populateSubmodelElement(Document document, Element root, ISubmodelElement submodelElement) {
        ReferableXMLConverter.populateReferableXML(document, root, submodelElement);
        HasKindXMLConverter.populateHasKindXML(document, root, submodelElement);
        HasSemanticsXMLConverter.populateHasSemanticsXML(document, root, submodelElement);
        QualifiableXMLConverter.populateQualifiableXML(document, root, submodelElement);
        HasDataSpecificationXMLConverter.populateHasDataSpecificationXML(document, root, submodelElement);
    }
}

