/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IRange;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.Range;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RangeXMLConverter
extends SubmodelElementXMLConverter {
    public static final String RANGE = "aas:range";
    public static final String MIN = "aas:min";
    public static final String MAX = "aas:max";

    public static Range parseRange(Map<String, Object> xmlObject) {
        String valueType = XMLHelper.getString(xmlObject.get("aas:valueType"));
        String min = XMLHelper.getString(xmlObject.get(MIN));
        String max = XMLHelper.getString(xmlObject.get(MAX));
        Range range = new Range(XMLHelper.convertAASXValueTypeToLocal(valueType), min, max);
        RangeXMLConverter.populateSubmodelElement(xmlObject, range);
        return range;
    }

    public static Element buildRange(Document document, IRange range) {
        String valueType;
        Object minObj;
        String min;
        String max;
        Element rangeRoot = document.createElement(RANGE);
        RangeXMLConverter.populateSubmodelElement(document, rangeRoot, range);
        Object maxObj = range.getMax();
        String string = max = maxObj == null ? null : maxObj.toString();
        if (max != null) {
            Element maxRoot = document.createElement(MAX);
            maxRoot.appendChild(document.createTextNode(max));
            rangeRoot.appendChild(maxRoot);
        }
        String string2 = min = (minObj = range.getMin()) == null ? null : minObj.toString();
        if (min != null) {
            Element minRoot = document.createElement(MIN);
            minRoot.appendChild(document.createTextNode(min));
            rangeRoot.appendChild(minRoot);
        }
        if ((valueType = range.getValueType().toString()) != null) {
            Element valueTypeRoot = document.createElement("aas:valueType");
            valueTypeRoot.appendChild(document.createTextNode(valueType));
            rangeRoot.appendChild(valueTypeRoot);
        }
        return rangeRoot;
    }
}

